(function() {
	tinymce.PluginManager.add( 'ip5_shortcodes_mce_button', function( editor, url ) {
		editor.addButton( 'ip5_shortcodes_mce_button', {
			title: 'IP5 Shortcodes',
			type: 'menubutton',
			icon: 'icon ip5-shortcodes-icon',
			menu: [


				/** Layout **/
				{
					text: 'レイアウト',
					menu: [

						/* Columns */
						{
							text: 'カラム',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - カラムを挿入',
									body: [

									// Column Size
									{
										type: 'listbox',
										name: 'columnSize',
										label: 'サイズ',
										'values': [
											{text: '1/2', value: 'one-half'},
											{text: '1/3', value: 'one-third'},
											{text: '2/3', value: 'two-third'},
											{text: '1/4', value: 'one-fourth'},
											{text: '3/4', value: 'three-fourth'},
											{text: '1/5', value: 'one-fifth'},
											{text: '2/5', value: 'two-fifth'},
											{text: '3/5', value: 'three-fifth'},
											{text: '4/5', value: 'four-fifth'},
											{text: '1/6', value: 'one-sixth'},
											{text: '5/6', value: 'five-sixth'}
										]
									},

									// Column Position
									{
										type: 'listbox',
										name: 'columnPosition',
										label: '場所',
										'values': [
											{text: '最初', value: 'first'},
											{text: '中間', value: 'middle'},
											{text: '最後', value: 'last'}
										]
									},

									// Column Content
									{
										type: 'textbox',
										name: 'columnContent',
										label: '内容',
										value: 'あのイーハトーヴォのすきとおった風、夏でも底に冷たさをもつ青いそら、うつくしい森で飾られたモリーオ市、郊外のぎらぎらひかる草の波。',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									} ],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_column size="' + e.data.columnSize + '" position="' + e.data.columnPosition + '" ]<br />' + e.data.columnContent + '<br />[/ip5_column]');
									}
								});
							}
						}, // End columns

						/* Columns - clearFloats */
						{
							text: 'フロート解除',
							onclick: function() {
								editor.insertContent( '[ip5_clear_floats]');
							}
						}, // End Columns - clearFloats

						/* Spacing */
						{
							text: '間隔',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - 間隔を挿入',
									body: [ {
										type: 'textbox', 
										name: 'spacingSize', 
										label: 'どれくらい空けるか（px）',
										value: '30'
									} ],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_spacing size="' + e.data.spacingSize + '"]');
									}
								});
							}
						}, // End spacing

						/* Dividers */
						{
							text: '区切り線',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - 区切り線を挿入',
									body: [

									// Divider Style
									{
										type: 'listbox',
										name: 'dividerStyle',
										label: '線の種類',
										'values': [
											{text: '実線', value: 'solid'},
											{text: '破線', value: 'dashed'},
											{text: '二重線', value: 'double'}
										]
									},

									// Divider Top Margin
									{
										type: 'textbox', 
										name: 'dividerTopMargin', 
										label: '上の間隔（px）',
										value: '20'
									},

									// Divider Bottom Margin
									{
										type: 'textbox', 
										name: 'dividerBottomMargin', 
										label: '下の間隔（px）',
										value: '20'
									} ],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_divider style="' + e.data.dividerStyle + '" margin_top="' + e.data.dividerTopMargin + '" margin_bottom="' + e.data.dividerBottomMargin + '"]');
									}
								});
							}
						} // End divider

					]
				}, // End Layout Section


				/** Elements **/
				{
					text: '部品',
					menu: [

						/* Heading */
						{
							text: '見出し',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - 見出しを挿入',
									body: [

									// Heading Title
									{
										type: 'textbox',
										name: 'headingTitle',
										label: '文字',
										value: 'そのころわたくしは、モリーオ市の博物局に勤めて居りました。'
									},

									// Heading Type
									{
										type: 'listbox',
										name: 'headingType',
										label: 'タグ',
										'values': [
											{text: 'h1', value: 'h1'},
											{text: 'h2', value: 'h2'},
											{text: 'h3', value: 'h3'},
											{text: 'h4', value: 'h4'},
											{text: 'h5', value: 'h5'},
											{text: 'span', value: 'span'},
											{text: 'div', value: 'div'}
										]
									},

									// Heading Style
									{
										type: 'listbox',
										name: 'headingStyle',
										label: '見出しサイズ',
										'values': [
											{text: '大', value: 'subheader--large'},
											{text: '中', value: 'subheader--medium'},
											{text: '小', value: 'subheader--small'},
											{text: '追伸', value: 'ps'}
										]
									}],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_heading type="' + e.data.headingType + '" style="' + e.data.headingStyle + '" title="' + e.data.headingTitle + '" ]' );
									}
								});
							}
						}, // End heading


						/* Boxes */
						{
							text: '囲み',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - 囲みを挿入',
									body: [

									// Box Color
									{
										type: 'listbox',
										name: 'boxSize',
										label: '大きさ',
										'values': [
											{text: '大', value: 'box--large'},
											{text: '中', value: 'box--medium'},
											{text: '小', value: 'box--small'}
										]
									},

									// Box Width
									{
										type: 'textbox',
										name: 'boxWidth',
										label: '幅 (%)',
										text: '100%'
									},

									// Box Title
									{
										type: 'textbox',
										name: 'boxTitle',
										label: 'タイトル',
										value: 'あのイーハトーヴォのすきとおった風'
									},

									// Box Title Size
									{
										type: 'listbox',
										name: 'boxTitleSize',
										label: 'タイトルの大きさ',
										'values': [
											{text: '普通', value: ''},
											{text: '小', value: '--small'}
										]
									},

									// Box Content
									{
										type: 'textbox',
										name: 'boxContent',
										label: '内容',
										value: 'あのイーハトーヴォのすきとおった風、夏でも底に冷たさをもつ青いそら、うつくしい森で飾られたモリーオ市、郊外のぎらぎらひかる草の波。',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									}],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_box size="' + e.data.boxSize + '" title="' + e.data.boxTitle + '" title_size="' + e.data.boxTitleSize + '" width="' + e.data.boxWidth + '"]<br />' + e.data.boxContent + '<br />[/ip5_box]' );
									}
								});
							}
						}, // End boxes


						/* Colored boxes */
						{
							text: '色背景',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - 色背景を挿入',
									body: [

									// Colored box color
									{
										type: 'listbox',
										name: 'coloredboxColor',
										label: '色',
										'values': [
											{text: '緑', value: 'colored-box--green'},
											{text: '青', value: 'colored-box--blue'},
											{text: '灰', value: 'colored-box--gray'},
											{text: '紫', value: 'colored-box--purple'},
											{text: '赤', value: 'colored-box--red'},
											{text: '黄', value: 'colored-box--yellow'}
										]
									},

									// Colored box Width
									{
										type: 'textbox',
										name: 'coloredboxWidth',
										label: '幅 (%)',
										text: '100%'
									},

									// Colored box Content
									{
										type: 'textbox', 
										name: 'coloredboxContent', 
										label: '内容',
										value: 'またそのなかでいっしょになったたくさんのひとたち、ファゼーロとロザーロ、羊飼のミーロや、顔の赤いこどもたち、地主のテーモ、山猫博士のボーガント・デストゥパーゴなど、いまこの暗い巨きな石の建物のなかで考えていると、みんなむかし風のなつかしい青い幻燈のように思われます。では、わたくしはいつかの小さなみだしをつけながら、しずかにあの年のイーハトーヴォの五月から十月までを書きつけましょう。'
									}],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_coloredbox color="' + e.data.coloredboxColor + '" width="' + e.data.coloredboxWidth + '"]' + e.data.coloredboxContent + '[/ip5_coloredbox]');
									}
								});
							}
						}, // End Colored boxes


						/* Ornaments */
						{
							text: '飾り背景',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - 飾り背景を挿入',
									body: [

									// Ornament design
									{
										type: 'listbox',
										name: 'ornamentDesign',
										label: 'デザイン',
										'values': [
											{text: 'メタル1', value: 'bg-deco-metal1'},
											{text: 'メタル2', value: 'bg-deco-metal2'},
											{text: 'メタル3', value: 'bg-deco-metal3'},
											{text: 'メタル4', value: 'bg-deco-metal4'},
											{text: '紙', value: 'bg-deco-paper1'},
											{text: '紙＋ピン（赤）', value: 'bg-deco-paper2'},
											{text: '紙＋ピン（青）', value: 'bg-deco-paper3'},
											{text: '紙＋ピン（緑）', value: 'bg-deco-paper4'},
											{text: '紙＋ピン（黄）', value: 'bg-deco-paper5'},
											{text: 'ポストイット（黄）', value: 'bg-deco-postit1'},
											{text: 'ポストイット（緑）', value: 'bg-deco-postit2'},
											{text: 'ポストイット（青）', value: 'bg-deco-postit3'},
											{text: 'ポストイット（赤）', value: 'bg-deco-postit4'},
											{text: 'ポストイット（灰）', value: 'bg-deco-postit5'},
											{text: 'マーカー（赤）', value: 'bg-deco-marker-p'},
											{text: 'マーカー（黄）', value: 'bg-deco-marker-y'},
											{text: 'マーカー（緑）', value: 'bg-deco-marker-g'},
											{text: 'マーカー（青）', value: 'bg-deco-marker-b'},
											{text: '黒板', value: 'bg-deco-chalkboard'},
											{text: '木板', value: 'bg-deco-woodboard1'},
											{text: '木枠', value: 'bg-deco-woodframe1'}
										]
									},

									// Ornament Width
									{
										type: 'textbox',
										name: 'ornamentWidth',
										label: '幅 (%)',
										text: '100%'
									},

									// Ornament Content
									{
										type: 'textbox', 
										name: 'ornamentContent', 
										label: '内容',
										value: 'またそのなかでいっしょになったたくさんのひとたち、ファゼーロとロザーロ、羊飼のミーロや、顔の赤いこどもたち、地主のテーモ、山猫博士のボーガント・デストゥパーゴなど、いまこの暗い巨きな石の建物のなかで考えていると、みんなむかし風のなつかしい青い幻燈のように思われます。では、わたくしはいつかの小さなみだしをつけながら、しずかにあの年のイーハトーヴォの五月から十月までを書きつけましょう。'
									}],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_ornament design="' + e.data.ornamentDesign + '" width="' + e.data.ornamentWidth + '"]' + e.data.ornamentContent + '[/ip5_ornament]');
									}
								});
							}
						}, // End Ornaments


						/* Q and A */
						{
							text: 'よくある質問',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - よくある質問',
									body: [

									// Q and A Question
									{
										type: 'textbox',
										name: 'faqQuestion',
										label: '質問',
										value: 'あのイーハトーヴォのすきとおった風、夏でも底に冷たさをもつ青いそら、うつくしい森で飾られたモリーオ市、郊外のぎらぎらひかる草の波。'
									},

									// Q and A Anser
									{
										type: 'textbox',
										name: 'faqAnser',
										label: '回答',
										value: 'またそのなかでいっしょになったたくさんのひとたち、ファゼーロとロザーロ、羊飼のミーロや、顔の赤いこどもたち、地主のテーモ、山猫博士のボーガント・デストゥパーゴなど、いまこの暗い巨きな石の建物のなかで考えていると、みんなむかし風のなつかしい青い幻燈のように思われます。では、わたくしはいつかの小さなみだしをつけながら、しずかにあの年のイーハトーヴォの五月から十月までを書きつけましょう。',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									}],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_faq question="' + e.data.faqQuestion + '"]' + e.data.faqAnser + '[/ip5_faq]');
									}
								});
							}
						}, // End Q and A


						/* Buttons */
						{
							text: 'ボタン',
							onclick: function() {
								editor.windowManager.open( {
									title: 'IP5 Shortcodes - ボタンを挿入',
									body: [

									// Button Text
									{
										type: 'textbox',
										name: 'buttonText',
										label: '文字',
										value: '今すぐ購入する'
									},

									// Button URL
									{
										type: 'textbox',
										name: 'buttonUrl',
										label: 'URL',
										value: 'http://www.info-plate.com/ip5-shortcodes/'
									},

									// Button Color
									{
										type: 'listbox',
										name: 'buttonColor',
										label: '色',
										'values': [
											{text: '基本色', value: ''},
											{text: '緑', value: 'button--green'},
											{text: '青', value: 'button--blue'},
											{text: '灰', value: 'button--gray'},
											{text: '紫', value: 'button--purple'},
											{text: '赤', value: 'button--red'},
											{text: '黄', value: 'button--yellow'},
											{text: '黒', value: 'button--black'}
										]
									},

									// Button Size
									{
										type: 'listbox',
										name: 'buttonSize',
										label: '大きさ',
										'values': [
											{text: '大', value: 'button--large'},
											{text: '中', value: 'button--medium'},
											{text: '小', value: 'button--small'}
										]
									},

									// Button Width
									{
										type: 'textbox',
										name: 'buttonWidth',
										label: '幅 (%)',
										text: ''
									},

									// Button Link Target
									{
										type: 'listbox',
										name: 'buttonLinkTarget',
										label: 'ターゲット',
										'values': [
											{text: '同じウィンドウ', value: 'self'},
											{text: '別のウィンドウ', value: 'blank'}
										]
									}],
									onsubmit: function( e ) {
										editor.insertContent( '[ip5_button url="' + e.data.buttonUrl + '" color="' + e.data.buttonColor + '" size="' + e.data.buttonSize + '" width="' + e.data.buttonWidth + '" target="' + e.data.buttonLinkTarget + '" ]' + e.data.buttonText + '[/ip5_button]');
									}
								});
							}
						}, // End button


					]
				}, // End Elements Section


			]
		});
	});
})();