<?php
/**
 * IP5WP Module Parts in the TinyMCE
 *
 */

// Adds button to mce
function ip5_shortcodes_add_mce_button_pro() {
	// check user permissions
	if ( !current_user_can( 'edit_posts' ) && !current_user_can( 'edit_pages' ) ) {
		return;
	}
	// check if WYSIWYG is enabled
	if ( 'true' == get_user_option( 'rich_editing' ) ) {
		add_filter( 'mce_external_plugins', 'ip5_shortcodes_add_tinymce_plugin_pro' );
		add_filter( 'mce_buttons', 'ip5_shortcodes_register_mce_button_pro' );
	}
}
add_action('admin_head', 'ip5_shortcodes_add_mce_button_pro');

// Loads js for the Button
function ip5_shortcodes_add_tinymce_plugin_pro($plugin_array) {
	$plugin_array['ip5_shortcodes_mce_button_pro'] = get_template_directory_uri().'/shortcodes/mce/js/ip5_shortcodes_tinymce_pro.js';
	return $plugin_array;
}

// Registers new button
function ip5_shortcodes_register_mce_button_pro( $buttons ) {
	array_push( $buttons, 'ip5_shortcodes_mce_button_pro' );
	return $buttons;
}

// Loads css for the Button
function ip5_shortcodes_mce_css_pro() {
	wp_enqueue_style('ip5_shortcodes-tc_pro', get_template_directory_uri().'/shortcodes/mce/css/ip5_shortcodes_tinymce_style_pro.css' );
}
add_action( 'admin_enqueue_scripts', 'ip5_shortcodes_mce_css_pro' );
