<?php

function ip5_shortcodes_add_mce_button() {
	// check user permissions
	if ( !current_user_can( 'edit_posts' ) && !current_user_can( 'edit_pages' ) ) {
		return;
	}
	// check if WYSIWYG is enabled
	if ( 'true' == get_user_option( 'rich_editing' ) ) {
		add_filter( 'mce_external_plugins', 'ip5_shortcodes_add_tinymce_plugin' );
		add_filter( 'mce_buttons', 'ip5_shortcodes_register_mce_button' );
	}
}
add_action('admin_head', 'ip5_shortcodes_add_mce_button');

function ip5_shortcodes_add_tinymce_plugin($plugin_array) {
   $plugin_array['ip5_shortcodes_mce_button'] = get_template_directory_uri().'/mce/js/ip5_shortcodes_tinymce.js';
   return $plugin_array;
}

function ip5_shortcodes_register_mce_button( $buttons ) {
	array_push( $buttons, 'ip5_shortcodes_mce_button' );
	return $buttons;
}

function ip5_shortcodes_mce_css() {
	wp_enqueue_style('ip5_shortcodes-tc', get_template_directory_uri().'/mce/css/ip5_shortcodes_tinymce_style.css' );
}
add_action( 'admin_enqueue_scripts', 'ip5_shortcodes_mce_css' );
