<?php

/* Allow shortcodes in widgets
   ========================================================================== */

add_filter('widget_text', 'do_shortcode');

/* Fix Shortcodes
   ========================================================================== */

if( !function_exists('ip5_fix_shortcodes') ) {
	function ip5_fix_shortcodes($content){
		$array = array (
			'<p>['    => '[',
			']</p>'   => ']',
			']<br />' => ']'
		);
		$content = strtr($content, $array);
		return $content;
	}
}
add_filter('the_content', 'ip5_fix_shortcodes');

/* Clear Floats
   ========================================================================== */

if( !function_exists('ip5_clear_floats_shortcode') ) {
	function ip5_clear_floats_shortcode() {
		return '<div class="ip5-clear-floats"></div>';
	}
}
add_shortcode( 'ip5_clear_floats', 'ip5_clear_floats_shortcode' );


/* ==========================================================================

   Layout

   ========================================================================== */

/* ==========================================================================
   Columns
   ========================================================================== */

if( !function_exists('ip5_column_shortcode') ) {
	function ip5_column_shortcode( $atts, $content = null ){
		extract( shortcode_atts( array(
			'size'       => 'one-third',
			'position'   => 'first',
			'class'      => '',
			'visibility' => 'all',
			'fade_in'    => 'false',
		), $atts ) );
		$fade_in_class = '';
		if ( $fade_in == 'true' ) {
			wp_enqueue_script('ip5_scroll_fade');
			$fade_in_class = 'ip5-fadein';
		}
		return '<div class="ip5-column ip5-' . $size . ' ip5-column-'.$position.' '. $class .' '. $fade_in_class .' ip5-'. $visibility .'">' . do_shortcode($content) . '</div>';
	}
}
add_shortcode('ip5_column', 'ip5_column_shortcode');


/* ==========================================================================
   Spacing
   ========================================================================== */

if( !function_exists('ip5_spacing_shortcode') ) {
	function ip5_spacing_shortcode( $atts ) {
		extract( shortcode_atts( array(
			'size'  => '20px',
			'class' => '',
		),
		$atts ) );
	 return '<hr class="ip5-spacing '. $class .'" style="height: '. intval($size) .'px" />';
	}
}
add_shortcode( 'ip5_spacing', 'ip5_spacing_shortcode' );


/* ==========================================================================
   Divider
   ========================================================================== */

if( !function_exists('ip5_divider_shortcode') ) {
	function ip5_divider_shortcode( $atts ) {
		extract( shortcode_atts( array(
			'style'         => 'fadeout',
			'margin_top'    => '20px',
			'margin_bottom' => '20px',
			'class'         => '',
			'visibility'    => 'all',
		),
		$atts ) );
		$style_attr = '';
		if ( $margin_top && $margin_bottom ) {  
			$style_attr = 'style="margin-top: '. intval($margin_top) .'px;margin-bottom: '. intval($margin_bottom) .'px;"';
		} elseif( $margin_bottom ) {
			$style_attr = 'style="margin-bottom: '. intval($margin_bottom) .'px;"';
		} elseif ( $margin_top ) {
			$style_attr = 'style="margin-top: '. intval($margin_top) .'px;"';
		} else {
			$style_attr = NULL;
		}
	 return '<hr class="ip5-divider '. $style .' '. $class .' ip5-'. $visibility .'" '.$style_attr.' />';
	}
}
add_shortcode( 'ip5_divider', 'ip5_divider_shortcode' );


/* ==========================================================================

   Basic Modules

   ========================================================================== */


/* ==========================================================================
   Sub header
   ========================================================================== */

if( !function_exists('ip5_heading_shortcode') ) {
	function ip5_heading_shortcode( $atts ) {
		extract( shortcode_atts( array(
			'title'         => __('Sample Heading', 'ip5'),
			'type'          => 'h2',
			'style'         => 'subheader--medium',
			'class'         => ''
		),
		$atts ) );

		// Load required scripts
		$style_attr = '';
		$output = '<div class="shortcode"><'.$type.' class="'. $style .'">';
			$output .= $title;
		$output .= '</'.$type.'></div>';
		
		return $output;
	}
}
add_shortcode( 'ip5_heading', 'ip5_heading_shortcode' );


/* ==========================================================================
   Headings
   ========================================================================== */


/* ==========================================================================
   Boxes
   ========================================================================== */

if( !function_exists('ip5_box_shortcode') ) { 
	function ip5_box_shortcode( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'size'  => 'box--large',
			'title' => '',
			'title_size' => '',
			'width' => '100%',
		), $atts ) );
		$output .= '<div class="'. $size .'" style="width:'. $width .'; ">';
		if ( $title !== '' ) $output .= '<div class="box__title'. $title_size .'">'. $title .'</div>';
		$output .= ' '. do_shortcode($content) .'</div>';
		return $output;
	}
}
add_shortcode( 'ip5_box', 'ip5_box_shortcode' );


/* ==========================================================================
   Frequently Asked Questions
   ========================================================================== */

if( !function_exists('ip5_faq_shortcode') ) { 
	function ip5_faq_shortcode( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'question' => '　',
		), $atts ) );
		$output .= '<div class="box--small"><div class="faq-q"><h4>'. $question .'</h4></div>';
		$output .= '<div class="faq-a">'. do_shortcode($content) .'</div></div>';
		return $output;
	}
}
add_shortcode( 'ip5_faq', 'ip5_faq_shortcode' );


/* ==========================================================================
   Testimonial
   ========================================================================== */


/* ==========================================================================
   Buttons
   ========================================================================== */

if( !function_exists('ip5_button_shortcode') ) {
	function ip5_button_shortcode( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'url'               => '',
			'color'             => 'button--green',
			'size'              => '',
			'width'              => '',
			'target'            => 'self',
			'title'             => '',
		), $atts ) );
		
		
		$border_radius_style = ( $border_radius ) ? 'style="border-radius:'. $border_radius .'"' : NULL;
		$rel = ( $rel ) ? 'rel="'.$rel.'"' : NULL;
		$icon_left = strtolower($icon_left);
		$icon_right = strtolower($icon_right);
		
		$button = NULL;
		$button .= '<a href="' . $url . '" class="button '. $size .' ' . $color . ' " target="_'.$target.'" title="'. $title .'" style="width:'. $width .'; ">';
			$button .= '<i class="fa fa-arrow-circle-o-right">&nbsp;</i>';
				$button .= $content;
		$button .= '</a>';
		return $button;
	}
}
add_shortcode('ip5_button', 'ip5_button_shortcode');


/* ==========================================================================
   Colored boxes
   ========================================================================== */

if( !function_exists('ip5_coloredbox_shortcode') ) { 
	function ip5_coloredbox_shortcode( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'color'  => 'colored-box--blue',
			'width' => '100%',
		), $atts ) );
		$output .= '<div class="colored-box '. $color .'" style="width:'. $width .';">';
		$output .= ' '. do_shortcode($content) .'</div>';
		return $output;
	}
}
add_shortcode( 'ip5_coloredbox', 'ip5_coloredbox_shortcode' );


/* ==========================================================================
   Ornaments
   ========================================================================== */

if( !function_exists('ip5_ornament_shortcode') ) { 
	function ip5_ornament_shortcode( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'design'  => 'bg-deco-paper2',
			'width' => '100%',
		), $atts ) );
		$output .= '<div class="'. $design .'" style="width:'. $width .';">';
		$output .= ' '. do_shortcode($content) .'</div>';
		return $output;
	}
}
add_shortcode( 'ip5_ornament', 'ip5_ornament_shortcode' );

