<?php
/*
Template Name: サイトマップ
*/
?>
<?php get_header(); ?>
<body <?php body_class(sitemap); ?>>
<div id="options" class="<?php $options = get_option('myd_theme_options'); if (!empty($options[layout])) { echo esc_html($options[layout]); } else { echo 'c2r'; } ?> <?php $options = get_option('myd_theme_options');echo esc_html($options['background_color_tone']);?>" >
	<?php get_template_part( 'banner' ); ?>

	<div class="l-container" id="container">

		<div class="l-main_sidebar1">
			<div class="l-main main" id="main" role="main">

				<article <?php post_class('entry frame--main'); ?> >
					<header class="entry-header">
						<h1 itemprop="headline">
							<span class="entry-title">サイトマップ</span>
						</h1>
					</header>

					<section>
						<?php
						$cats = get_categories('parent=0&hide_empty=0');
						foreach ($cats as $cat) :
							$desc_cats = get_categories('child_of=' . $cat->cat_ID);
							$desc_cat_ids = array($cat->cat_ID);
							foreach ($desc_cats as $desc_cat) {
								array_push($desc_cat_ids, $desc_cat->cat_ID);
							}
							$desc_cat_ids_str = implode(',', $desc_cat_ids);
							$cat_posts = get_posts('category=' . $desc_cat_ids_str . '&numberposts=-1&orderby=post_date&order=desc');
							if ($cat_posts) : ?>
					
						<h2 class="h4"><a href="<?php $category_link = get_category_link( $cat->cat_ID ); echo $category_link; ?>"><?php echo($cat->cat_name); ?></a></h2>
						<p><?php if (category_description($cat->cat_ID) != "&nbsp;") {echo category_description($cat->cat_ID); } ?></p>
						<ul>
							<?php $p_cnt = 0; ?>
							<?php $n = count($cat_posts); ?>
							<?php foreach ($cat_posts as $post) : setup_postdata($post); ?>
									<?php if ($p_cnt==$n-1) : ?>
										<li class="last">
									<?php else : ?>
										<li>
									<?php endif; ?>
									<?php $p_cnt += 1; ?>
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
							<?php endforeach; ?>
						</ul>
						<?php endif; ?>
						<?php endforeach; ?>
					
						<h2 class="h4">固定ページ</h2>
						<ul>
							<?php wp_list_pages('title_li=&depth=-1'); ?>
						</ul>
					</section>
				</article>
			</div>

			<?php get_sidebar('1'); ?>
		</div>

		<?php get_sidebar('2'); ?>
	</div>

	<?php get_footer(); ?>