
/*! ==========================================================================

   INFOPLATE 5 function.js v.1.0.1 2014.5.21

   ========================================================================== */


/* Gloval navigation : レスポンシブメニュー http://www.webdesignleaves.com/wp/htmlcss/564/
   ========================================================================== */

$(function() {
  var pull = $('.global-navi-btn');
  var menu = $('.global-navi .global-navi-inner');
  $(pull).on('click', function(e) {
    e.preventDefault();
    menu.slideToggle();
  });
  $(window).resize(function(){
    var w = $(window).width();
    // :hidden の代わりに css('display') で判定
    if(w > 320 && menu.css('display') == 'none') {
      menu.removeAttr('style');
    }
  });
});

/* g-navi : 小メニューがある時にクラスを付与
   ========================================================================== */

$(function() {
  jQuery(".global-navi-inner > ul > li").has("ul").addClass("submenu");
  jQuery(".global-navi-inner > ul > li > ul > li").has("ul").addClass("submenu");
  jQuery(".global-navi-inner > ul > li > ul > li > ul > li").has("ul").addClass("submenu");
});


/* g-navi : 現在地にクラスを付与
   ========================================================================== */

$(function(){
    var loc = location.href;
    var file = loc.substring(loc.lastIndexOf("/")+1,loc.length);
    $('.global-navi-inner a[href$="'+file+'"]').addClass('active');
});


/* スムーズスクロール
   ========================================================================== */

$(function() {
   // #で始まるアンカーをクリックした場合に処理
   $('a[href*=#]').click(function() {
      // スクロールの速度
      var speed = 500;// ミリ秒
      // アンカーの値取得
      var href= $(this).attr("href");
      // 移動先を取得
      var target = $(href == "#" || href == "" ? 'html' : href);
      // 移動先を数値で取得
      var position = target.offset().top;
      // スムーススクロール
      $('body,html').animate({scrollTop:position}, speed, 'swing');
      return false;
   });
});


/* ちょっとスクロールしたら「ページの先頭へ」を表示
   ========================================================================== */

$(function() {
    var topBtn = $('.pagetop');
    topBtn.hide();
    //スクロールが100に達したらボタン表示
    $(window).scroll(function () {
        if ($(this).scrollTop() > 100) {
            topBtn.fadeIn();
        } else {
            topBtn.fadeOut();
        }
    });
    //スクロールしてトップ
    topBtn.click(function () {
        $('body,html').animate({
            scrollTop: 0
        }, 500);
        return false;
    });
});


/* tableの偶数行・奇数行にクラスを付ける
   ========================================================================== */

$(function() {
  $("table").find("tr:odd").addClass("odd");
  $("table").find("tr:even").addClass("even");
});


/* .subheader-- の子要素に .inner をつける
   ========================================================================== */

$(function() {
  $(".subheader--large, .subheader--medium, .subheader--small, .entry-title").wrapInner("<span class='inner'></span>");
});


/* アコーディオンメニュー
   ========================================================================== */

$(function() {
    $(".toggle-body").hide();
    $(".toggle-show").show(); // showを付けると開く
    $(".toggle-head").click(function(){
        var click = $("+.toggle-body",this);
        click.slideToggle();
        return false;
    });
});


/* カウントダウンタイマー
   ========================================================================== */

function CountdownTimer(elm,tl,mes){
  this.initialize.apply(this,arguments);
}
CountdownTimer.prototype={
  initialize:function(elm,tl,mes) {
    this.elem = document.getElementById(elm);
    this.tl = tl;
    this.mes = mes;
  },countDown:function(){
    var timer='';
    var today=new Date();
    var day=Math.floor((this.tl-today)/(24*60*60*1000));
    var hour=Math.floor(((this.tl-today)%(24*60*60*1000))/(60*60*1000));
    var min=Math.floor(((this.tl-today)%(24*60*60*1000))/(60*1000))%60;
    var sec=Math.floor(((this.tl-today)%(24*60*60*1000))/1000)%60%60;
    var milli=Math.floor(((this.tl-today)%(24*60*60*1000))/10)%100;
    var me=this;

    if( ( this.tl - today ) > 0 ){
    
        if (day) timer += '<span class="num day">'+day+'</span>日';
        if (hour) timer += '<span class="num hour">'+hour+'</span>時間';
        timer += '<span class="num min">'+this.addZero(min)+'</span>分<span class="num sec">'+this.addZero(sec)+'</span>秒<span class="num milli">'+this.addZero(milli)+'</span>';
        this.elem.innerHTML = timer;
        tid = setTimeout( function(){me.countDown();},10 );
    }else{
        this.elem.innerHTML = this.mes;
        return;
    }
  },addZero:function(num){ return ('0'+num).slice(-2); }
}


/* 埋め込みiframeにwrap（youtube, vimeo, google map）
   ========================================================================== */

jQuery(document).ready(function () {
  jQuery('iframe[src*="youtube.com"], iframe[src*="vimeo.com"], iframe[src*="google.com/maps"]').wrap('<div class="iframe-wrap" />');
});

