<?php

/*-----------------------------------------------------------------------------------*/
/* 最新情報 */
/*-----------------------------------------------------------------------------------*/

class Recent_Entries extends WP_Widget {

	function Recent_Entries() {
		$widget_ops = array('classname' => 'recent-entries rewg', 'description' => '条件を指定して最近の投稿を表示');
		$this->WP_Widget('Recent_Entries', '最新情報', $widget_ops);
	}

	function output( $r, $excerpt = false , $thumbnail = false , $show_date = false ) {
		if ($r->have_posts()) :
			?>
				<ul>
					<?php
						$lastpostcnt = 0;
									while ($r->have_posts()) : $r->the_post(); 
							$lastpostcnt++;
							if ( $lastpostcnt == $r->post_count ) {
								echo '<li class="widget-item">';
							} else {
								echo '<li class="widget-item">';
							} ?>

							<?php if ( $thumbnail && has_post_thumbnail() ) {
								echo '<div class="widget-item-entry-img">';
								the_post_thumbnail();
								echo '</div>';
							} ?>

								<?php if ( "yearmonthdate" == $show_date ) {
									echo '<div class="widget-item-entry-date">&nbsp;';
									the_time('Y年m月d日');
									echo '</div>';
								} else if ( "monthdate" == $show_date ) {
									echo '<div class="widget-item-entry-date">&nbsp;';
									the_time('m月d日');
									echo '</div>';
								} else if ( "diff" == $show_date ) {
									$difftime = strtotime("now") - strtotime(get_the_time("Y-m-d"));
									$diffday = (int) ($difftime / 86400);
									if ( $diffday >= 2 ) {
										echo '<div class="widget-item-entry-date">&nbsp;';
										printf(__('%s 日前'), $diffday);
										echo '</div>';
									} else if ( $diffday >= 1 ) {
										echo '<div class="widget-item-entry-date">&nbsp;';
										printf(__('%s 日前'), $diffday);
										echo '</div>';
									} else {
										echo '<div class="widget-item-entry-date">&nbsp;';
										echo(__('24時間以内'));
									echo '</div>';
									}
							} ?>

							<div class="widget-item-entry-title">
								<a href="<?php the_permalink() ?>" title="Permanent link to <?php echo esc_attr(get_the_title() ? get_the_title() : get_the_ID()); ?>"><?php if ( get_the_title() ) the_title(); else the_ID(); ?></a>
							</div>

							<?php if ( $excerpt ) {
								echo the_excerpt();
							} ?>

							</li>

						<?php endwhile; ?>
				</ul>
		<?php
		wp_reset_query();  // Restore global post data stomped by the_post().
	endif;
	}

	function number($num) {
		if ( !$number = (int) $num )
			$number = get_option('posts_per_page');
		else if ( $number < 1 )
			$number = 1;
		return $number;
	}

	function orderby($rand) {
		if ( $rand ) {
			return "rand";
		} else {
			return "date";
		}
	}

	function widget($args, $instance) {
		extract($args, EXTR_SKIP);

		$title = apply_filters('widget-title', empty($instance['title']) ?最新情報 : $instance['title']);
		$number = $this->number($instance['number']);
		$orderby = $this->orderby($instance['rand']);
		$category = empty( $instance['category'] ) ? '' : $instance['category'];
		$r = new WP_Query(array('showposts' => $number, 'nopaging' => 0, 'post_status' => 'publish', 'orderby' => $orderby, 'cat' => $category, 'caller_get_posts' => 1));

		echo $before_widget;
		if ( $title ) echo $before_title . $title . $after_title;
		$this->output( $r, $instance['excerpt'], $instance['thumbnail'], $instance['show_date'] );
		echo $after_widget;

	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = esc_attr($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$instance['rand'] = (int) $new_instance['rand'];
		$instance['excerpt'] = (int) $new_instance['excerpt'];
		$instance['thumbnail'] = (int) $new_instance['thumbnail'];
		$instance['show_date'] = esc_attr($new_instance['show_date']);
		$instance['category'] = implode(", ",$new_instance['category']);
		return $instance;
	}

	function form_title( $title ) {
		$title = esc_attr($title);
		?>
			<p><label for="<?php echo $this->get_field_id('title'); ?>">タイトル:</label> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>
			<?php
	}

	function form_number( $number ) {
		if ( !$number = (int) $number )
			$number = get_option('posts_per_page');
		?>
			<p><label for="<?php echo $this->get_field_id('number'); ?>">表示する投稿数:</label> <input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>
			<?php
	}

	function form_category( $category ) {
		if ( $category ) {
			$catarray = explode( ", ",$category );
		} else {
			$catarray = array();
		}
		?>
			<p><label>表示するカテゴリー</label><br />
			<?php
			$categories = get_terms('category', 'orderby=id&hide_empty=0');

		foreach ( $categories as $catdata ) {
			$cat_id = $catdata->term_id;
			$name = esc_html( apply_filters('the_category', $catdata->name));
			$checked = '';
			if (in_array( $cat_id, $catarray )) {
				$checked = 'checked="checked"';
			}
			echo '<input type="checkbox" id="'.$this->get_field_id('category').'['.$cat_id.']" name="'.$this->get_field_name('category').'['.$cat_id.']" value="'.$cat_id.'" '.$checked.' class="checkbox">';
			echo '<label for="'.$this->get_field_id('category').'['.$cat_id.']">';
			echo $name;
			echo '</label><br />';
			}
			?></p>
		<?php
	}

	function form_rand( $rand ) {
		?>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('rand'); ?>" name="<?php echo $this->get_field_name('rand'); ?>" value="1" <?php if( $rand ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('rand'); ?>">ランダムに表示</label></p>
			<?php
	}

	function form_excerpt( $excerpt ) {
		?>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('excerpt'); ?>" name="<?php echo $this->get_field_name('excerpt'); ?>" value="1" <?php if( $excerpt ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('excerpt'); ?>">記事の概要を表示 </label></p>
		<?php
	}

	function form_thumbnail( $thumbnail ) {
		?>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('thumbnail'); ?>" name="<?php echo $this->get_field_name('thumbnail'); ?>" value="1" <?php if( $thumbnail ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('thumbnail'); ?>">アイキャッチを表示 </label></p>
		<?php
	}

	function form_show_date( $show_date ) {
		$show_date = esc_attr($show_date);
		?>
			<p>
				<label for="<?php echo $this->get_field_id('show_date'); ?>">日付を表示</label>
				<select name="<?php echo $this->get_field_name('show_date'); ?>" id="<?php echo $this->get_field_id('show_date'); ?>">
				<option value="none"<?php selected( $show_date, 'none' ); ?>>表示しない</option>
				<option value="yearmonthdate"<?php selected( $show_date, 'yearmonthdate' ); ?>>○年○月○日</option>
				<option value="monthdate"<?php selected( $show_date, 'monthdate' ); ?>>○月○日</option>
				<option value="diff"<?php selected( $show_date, 'diff' ); ?>>○○日前</option>
				</select>
			</p>
		<?php
	}

	function form( $instance ) {
		$this->form_title( $instance['title'] );
		$this->form_number( $instance['number'] );
		$this->form_category( $instance['category'] );
		$this->form_rand( $instance['rand'] );
		$this->form_excerpt( $instance['excerpt'] );
		$this->form_thumbnail( $instance['thumbnail'] );
		$this->form_show_date( $instance['show_date'] );
	}
}

add_action('widgets_init', create_function('', 'return register_widget("Recent_Entries");'));


/*-----------------------------------------------------------------------------------*/
/* バナー広告表示（３列） */
/*-----------------------------------------------------------------------------------*/

class Banners_3 extends WP_Widget {

	function Banners_3() {
		$widget_ops = array('classname' => 'banners-3', 'description' => '広告リンクを３つ、画像付きで表示');
		$this->WP_Widget('Banners_3', '広告リンク（３）', $widget_ops);}

	function widget($args, $instance) {
		extract( $args );
		?>
			<?php echo $before_widget ?>
			<div class="banners">
			<?php if($instance['title'] == NULL ){ echo "";} else { echo '<h3 class="widget-title">' . $instance['title'] . '</h3>';} ?>
			<div class="c3">
			<div class="unit">
				<div class="unit1">
					<a href="<?php if($instance['adv3_url_1'] == NULL ){ echo "";} else { echo $instance['adv3_url_1'] ;} ?>" <?php if($instance['adv3_target_1'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv3_image_1'] == NULL ){ echo "";} else { echo '<div class="banners-image"><img src="' . $instance['adv3_image_1'] . '" /></div>';} ?>
					</a>
					<a class="banners-title" href="<?php if($instance['adv3_url_1'] == NULL ){ echo "";} else { echo $instance['adv3_url_1'] ;} ?>" <?php if($instance['adv3_target_1'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv3_name_1'] == NULL ){ echo "";} else { echo $instance['adv3_name_1'] ;} ?>
					</a>
					<?php if($instance['adv3_text_1'] == NULL ){ echo "";} else { echo '<div class="banners-text">';} ?>
						<?php if($instance['adv3_text_1'] == NULL ){ echo "";} else { echo $instance['adv3_text_1'];} ?>
					<?php if($instance['adv3_text_1'] == NULL ){ echo "";} else { echo '</div>';} ?>
				</div>
			</div>

			<div class="unit">
				<div class="unit2">
					<a href="<?php if($instance['adv3_url_2'] == NULL ){ echo "";} else { echo $instance['adv3_url_2'] ;} ?>" <?php if($instance['adv3_target_2'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv3_image_2'] == NULL ){ echo "";} else { echo '<div class="banners-image"><img src="' . $instance['adv3_image_2'] . '" /></div>';} ?>
					</a>
					<a class="banners-title" href="<?php if($instance['adv3_url_2'] == NULL ){ echo "";} else { echo $instance['adv3_url_2'] ;} ?>" <?php if($instance['adv3_target_2'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv3_name_2'] == NULL ){ echo "";} else { echo $instance['adv3_name_2'] ;} ?>
					</a>
					<?php if($instance['adv3_text_2'] == NULL ){ echo "";} else { echo '<div class="banners-text">';} ?>
						<?php if($instance['adv3_text_2'] == NULL ){ echo "";} else { echo $instance['adv3_text_2'];} ?>
					<?php if($instance['adv3_text_2'] == NULL ){ echo "";} else { echo '</div>';} ?>
				</div>
			</div>

			<div class="unit">
			<div class="unit3">
					<a href="<?php if($instance['adv3_url_3'] == NULL ){ echo "";} else { echo $instance['adv3_url_3'] ;} ?>" <?php if($instance['adv3_target_3'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
					<?php if($instance['adv3_image_3'] == NULL ){ echo "";} else { echo '<div class="banners-image"><img src="' . $instance['adv3_image_3'] . '" /></div>';} ?>
					</a>
					<a class="banners-title" href="<?php if($instance['adv3_url_3'] == NULL ){ echo "";} else { echo $instance['adv3_url_3'] ;} ?>" <?php if($instance['adv3_target_3'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
					<?php if($instance['adv3_name_3'] == NULL ){ echo "";} else { echo $instance['adv3_name_3'] ;} ?>
					</a>
				<?php if($instance['adv3_text_3'] == NULL ){ echo "";} else { echo '<div class="banners-text">';} ?>
					<?php if($instance['adv3_text_3'] == NULL ){ echo "";} else { echo $instance['adv3_text_3'];} ?>
				<?php if($instance['adv3_text_3'] == NULL ){ echo "";} else { echo '</div>';} ?>
			</div>
			</div>

			</div>
			</div>
			<?php echo $after_widget ?>
		<?php
	}


	function update($new_instance, $old_instance) {
		return $new_instance;
	}


	function form($instance) {
		$title = $instance['title'] ? $instance['title'] : "";
		$adv3_image_1 = $instance['adv3_image_1'] ? $instance['adv3_image_1'] : "";
		$adv3_url_1 = $instance['adv3_url_1'] ? $instance['adv3_url_1'] : "";
		$adv3_target_1 = $instance['adv3_target_1'] ? $instance['adv3_target_1'] : "";
		$adv3_name_1 = $instance['adv3_name_1'] ? $instance['adv3_name_1'] : "";
		$adv3_text_1 = $instance['adv3_text_1'] ? $instance['adv3_text_1'] : "";
		$adv3_image_2 = $instance['adv3_image_2'] ? $instance['adv3_image_2'] : "";
		$adv3_url_2 = $instance['adv3_url_2'] ? $instance['adv3_url_2'] : "";
		$adv3_target_2 = $instance['adv3_target_2'] ? $instance['adv3_target_2'] : "";
		$adv3_name_2 = $instance['adv3_name_2'] ? $instance['adv3_name_2'] : "";
		$adv3_text_2 = $instance['adv3_text_2'] ? $instance['adv3_text_2'] : "";
		$adv3_image_3 = $instance['adv3_image_3'] ? $instance['adv3_image_3'] : "";
		$adv3_url_3 = $instance['adv3_url_3'] ? $instance['adv3_url_3'] : "";
		$adv3_target_3 = $instance['adv3_target_3'] ? $instance['adv3_target_3'] : "";
		$adv3_name_3 = $instance['adv3_name_3'] ? $instance['adv3_name_3'] : "";
		$adv3_text_3 = $instance['adv3_text_3'] ? $instance['adv3_text_3'] : "";
		?>

		<p><label for="<?php echo $this->get_field_id('title'); ?>">
			タイトル:
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</label></p>

		<fieldset>
			<legend>広告１</legend>
			<p><label for="<?php echo $this->get_field_id('adv3_url_1'); ?>">
				リンク先のURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_url_1'); ?>" name="<?php echo $this->get_field_name('adv3_url_1'); ?>" type="text" value="<?php echo $adv3_url_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_image_1'); ?>">
				画像ファイルのURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_image_1'); ?>" name="<?php echo $this->get_field_name('adv3_image_1'); ?>" type="text" value="<?php echo $adv3_image_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_name_1'); ?>">
				名前:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_name_1'); ?>" name="<?php echo $this->get_field_name('adv3_name_1'); ?>" type="text" value="<?php echo $adv3_name_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_text_1'); ?>">
				説明:
				<textarea class="widefat" id="<?php echo $this->get_field_id('adv3_text_1'); ?>" name="<?php echo $this->get_field_name('adv3_text_1'); ?>"><?php echo $adv3_text_1; ?></textarea>
			</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('adv3_target_1'); ?>" name="<?php echo $this->get_field_name('adv3_target_1'); ?>" value="1" <?php if( $adv3_target_1 ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('adv3_target_1'); ?>">別窓で開く</label></p>
		</fieldset>

		<fieldset>
			<legend>広告２</legend>
			<p><label for="<?php echo $this->get_field_id('adv3_url_2'); ?>">
				リンク先のURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_url_2'); ?>" name="<?php echo $this->get_field_name('adv3_url_2'); ?>" type="text" value="<?php echo $adv3_url_2; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_image_2'); ?>">
				画像ファイルのURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_image_2'); ?>" name="<?php echo $this->get_field_name('adv3_image_2'); ?>" type="text" value="<?php echo $adv3_image_2; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_name_2'); ?>">
				名前:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_name_2'); ?>" name="<?php echo $this->get_field_name('adv3_name_2'); ?>" type="text" value="<?php echo $adv3_name_2; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_text_2'); ?>">
				説明:
				<textarea class="widefat" id="<?php echo $this->get_field_id('adv3_text_2'); ?>" name="<?php echo $this->get_field_name('adv3_text_2'); ?>"><?php echo $adv3_text_2; ?></textarea>
			</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('adv3_target_2'); ?>" name="<?php echo $this->get_field_name('adv3_target_2'); ?>" value="1" <?php if( $adv3_target_2 ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('adv3_target_2'); ?>">別窓で開く</label></p>
		</fieldset>

		<fieldset>
			<legend>広告３</legend>
			<p><label for="<?php echo $this->get_field_id('adv3_url_3'); ?>">
				リンク先のURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_url_3'); ?>" name="<?php echo $this->get_field_name('adv3_url_3'); ?>" type="text" value="<?php echo $adv3_url_3; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_image_3'); ?>">
				画像ファイルのURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_image_3'); ?>" name="<?php echo $this->get_field_name('adv3_image_3'); ?>" type="text" value="<?php echo $adv3_image_3; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_name_3'); ?>">
				名前:
				<input class="widefat" id="<?php echo $this->get_field_id('adv3_name_3'); ?>" name="<?php echo $this->get_field_name('adv3_name_3'); ?>" type="text" value="<?php echo $adv3_name_3; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv3_text_3'); ?>">
				説明:
				<textarea class="widefat" id="<?php echo $this->get_field_id('adv3_text_3'); ?>" name="<?php echo $this->get_field_name('adv3_text_3'); ?>"><?php echo $adv3_text_3; ?></textarea>
			</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('adv3_target_3'); ?>" name="<?php echo $this->get_field_name('adv3_target_3'); ?>" value="1" <?php if( $adv3_target_3 ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('adv3_target_3'); ?>">別窓で開く</label></p>
		</fieldset>

		<?php
	}
}

add_action('widgets_init', create_function('', 'return register_widget("Banners_3");'));


/*-----------------------------------------------------------------------------------*/
/* バナー広告表示（２列） */
/*-----------------------------------------------------------------------------------*/

class Banners_2 extends WP_Widget {

	function Banners_2() {
		$widget_ops = array( 'description' => '広告リンクを２つ、画像付きで表示');
		$this->WP_Widget('banners-2', '広告リンク（２）', $widget_ops);}

	function widget($args, $instance) {
		extract( $args );
		?>
			<?php echo $before_widget ?>
			<div class="banners">
			<?php if($instance['title'] == NULL ){ echo "";} else { echo '<h3 class="widget-title">' . $instance['title'] . '</h3>';} ?>
			<div class="c2">
			<div class="unit">
				<div class="unit1">
					<a href="<?php if($instance['adv2_url_1'] == NULL ){ echo "";} else { echo $instance['adv2_url_1'] ;} ?>" <?php if($instance['adv2_target_1'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv2_image_1'] == NULL ){ echo "";} else { echo '<div class="banners-image"><img src="' . $instance['adv2_image_1'] . '" /></div>';} ?>
					</a>
					<a class="banners-title" href="<?php if($instance['adv2_url_1'] == NULL ){ echo "";} else { echo $instance['adv2_url_1'] ;} ?>" <?php if($instance['adv2_target_1'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv2_name_1'] == NULL ){ echo "";} else { echo $instance['adv2_name_1'] ;} ?>
					</a>
					<?php if($instance['adv2_text_1'] == NULL ){ echo "";} else { echo '<div class="banners-text">';} ?>
						<?php if($instance['adv2_text_1'] == NULL ){ echo "";} else { echo $instance['adv2_text_1'];} ?>
					<?php if($instance['adv2_text_1'] == NULL ){ echo "";} else { echo '</div>';} ?>
				</div>
			</div>

			<div class="unit">
				<div class="unit2">
					<a href="<?php if($instance['adv2_url_2'] == NULL ){ echo "";} else { echo $instance['adv2_url_2'] ;} ?>" <?php if($instance['adv2_target_2'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv2_image_2'] == NULL ){ echo "";} else { echo '<div class="banners-image"><img src="' . $instance['adv2_image_2'] . '" /></div>';} ?>
					</a>
					<a class="banners-title" href="<?php if($instance['adv2_url_2'] == NULL ){ echo "";} else { echo $instance['adv2_url_2'] ;} ?>" <?php if($instance['adv2_target_2'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv2_name_2'] == NULL ){ echo "";} else { echo $instance['adv2_name_2'] ;} ?>
					</a>
					<?php if($instance['adv2_text_2'] == NULL ){ echo "";} else { echo '<div class="banners-text">';} ?>
						<?php if($instance['adv2_text_2'] == NULL ){ echo "";} else { echo $instance['adv2_text_2'];} ?>
					<?php if($instance['adv2_text_2'] == NULL ){ echo "";} else { echo '</div>';} ?>
				</div>
			</div>

			</div>
			</div>
			<?php echo $after_widget ?>
		<?php
	}

	function update($new_instance, $old_instance) {
		return $new_instance;
	}

	function form($instance) {
		$title = $instance['title'] ? $instance['title'] : "";
		$adv2_image_1 = $instance['adv2_image_1'] ? $instance['adv2_image_1'] : "";
		$adv2_url_1 = $instance['adv2_url_1'] ? $instance['adv2_url_1'] : "";
		$adv2_target_1 = $instance['adv2_target_1'] ? $instance['adv2_target_1'] : "";
		$adv2_name_1 = $instance['adv2_name_1'] ? $instance['adv2_name_1'] : "";
		$adv2_text_1 = $instance['adv2_text_1'] ? $instance['adv2_text_1'] : "";
		$adv2_image_2 = $instance['adv2_image_2'] ? $instance['adv2_image_2'] : "";
		$adv2_url_2 = $instance['adv2_url_2'] ? $instance['adv2_url_2'] : "";
		$adv2_target_2 = $instance['adv2_target_2'] ? $instance['adv2_target_2'] : "";
		$adv2_name_2 = $instance['adv2_name_2'] ? $instance['adv2_name_2'] : "";
		$adv2_text_2 = $instance['adv2_text_2'] ? $instance['adv2_text_2'] : "";
		?>

		<p><label for="<?php echo $this->get_field_id('title'); ?>">
			タイトル:
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</label></p>
		<fieldset>
			<legend>広告１</legend>
			<p><label for="<?php echo $this->get_field_id('adv2_url_1'); ?>">
				リンク先のURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv2_url_1'); ?>" name="<?php echo $this->get_field_name('adv2_url_1'); ?>" type="text" value="<?php echo $adv2_url_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv2_image_1'); ?>">
				画像ファイルのURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv2_image_1'); ?>" name="<?php echo $this->get_field_name('adv2_image_1'); ?>" type="text" value="<?php echo $adv2_image_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv2_name_1'); ?>">
				名前:
				<input class="widefat" id="<?php echo $this->get_field_id('adv2_name_1'); ?>" name="<?php echo $this->get_field_name('adv2_name_1'); ?>" type="text" value="<?php echo $adv2_name_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv2_text_1'); ?>">
				説明:
				<textarea class="widefat" id="<?php echo $this->get_field_id('adv2_text_1'); ?>" name="<?php echo $this->get_field_name('adv2_text_1'); ?>"><?php echo $adv2_text_1; ?></textarea>
			</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('adv2_target_1'); ?>" name="<?php echo $this->get_field_name('adv2_target_1'); ?>" value="1" <?php if( $adv2_target_1 ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('adv2_target_1'); ?>">別窓で開く</label></p>
		</fieldset>

		<fieldset>
			<legend>広告２</legend>
			<p><label for="<?php echo $this->get_field_id('adv2_url_2'); ?>">
				リンク先のURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv2_url_2'); ?>" name="<?php echo $this->get_field_name('adv2_url_2'); ?>" type="text" value="<?php echo $adv2_url_2; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv2_image_2'); ?>">
				画像ファイルのURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv2_image_2'); ?>" name="<?php echo $this->get_field_name('adv2_image_2'); ?>" type="text" value="<?php echo $adv2_image_2; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv2_name_2'); ?>">
				名前:
				<input class="widefat" id="<?php echo $this->get_field_id('adv2_name_2'); ?>" name="<?php echo $this->get_field_name('adv2_name_2'); ?>" type="text" value="<?php echo $adv2_name_2; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv2_text_2'); ?>">
				説明:
				<textarea class="widefat" id="<?php echo $this->get_field_id('adv2_text_2'); ?>" name="<?php echo $this->get_field_name('adv2_text_2'); ?>"><?php echo $adv2_text_2; ?></textarea>
			</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('adv2_target_2'); ?>" name="<?php echo $this->get_field_name('adv2_target_2'); ?>" value="1" <?php if( $adv2_target_2 ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('adv2_target_2'); ?>">別窓で開く</label></p>
		</fieldset>

		<?php
	}
}

add_action('widgets_init', create_function('', 'return register_widget("Banners_2");'));


/*-----------------------------------------------------------------------------------*/
/* バナー広告表示（１列） */
/*-----------------------------------------------------------------------------------*/

class Banners_1 extends WP_Widget {

	function Banners_1() {
		$widget_ops = array( 'description' => '広告リンクを１つ、画像付きで表示');
		$this->WP_Widget('banners-1', '広告リンク（１）', $widget_ops);}

	function widget($args, $instance) {
		extract( $args );
		?>
			<?php echo $before_widget ?>
			<div class="banners">
			<?php if($instance['title'] == NULL ){ echo "";} else { echo '<h3 class="widget-title">' . $instance['title'] . '</h3>';} ?>
			<div class="c1">
			<div class="unit">
				<div class="unit2">
					<a href="<?php if($instance['adv1_url_1'] == NULL ){ echo "";} else { echo $instance['adv1_url_1'] ;} ?>" <?php if($instance['adv1_target_1'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv1_image_1'] == NULL ){ echo "";} else { echo '<div class="banners-image"><img src="' . $instance['adv1_image_1'] . '" /></div>';} ?>
					</a>
					<a class="banners-title" href="<?php if($instance['adv1_url_1'] == NULL ){ echo "";} else { echo $instance['adv1_url_1'] ;} ?>" <?php if($instance['adv1_target_1'] == NULL ){ echo "";} else { echo 'target="_blank"' ;} ?>>
						<?php if($instance['adv1_name_1'] == NULL ){ echo "";} else { echo $instance['adv1_name_1'] ;} ?>
					</a>
					<?php if($instance['adv1_text_1'] == NULL ){ echo "";} else { echo '<div class="banners-text">';} ?>
						<?php if($instance['adv1_text_1'] == NULL ){ echo "";} else { echo $instance['adv1_text_1'];} ?>
					<?php if($instance['adv1_text_1'] == NULL ){ echo "";} else { echo '</div>';} ?>
				</div>
			</div>

			</div>
			</div>
			<?php echo $after_widget ?>
		<?php
	}

	function update($new_instance, $old_instance) {
		return $new_instance;
	}

	function form($instance) {
		$title = $instance['title'] ? $instance['title'] : "";
		$adv1_image_1 = $instance['adv1_image_1'] ? $instance['adv1_image_1'] : "";
		$adv1_url_1 = $instance['adv1_url_1'] ? $instance['adv1_url_1'] : "";
		$adv1_target_1 = $instance['adv1_target_1'] ? $instance['adv1_target_1'] : "";
		$adv1_name_1 = $instance['adv1_name_1'] ? $instance['adv1_name_1'] : "";
		$adv1_text_1 = $instance['adv1_text_1'] ? $instance['adv1_text_1'] : "";
		?>

		<p><label for="<?php echo $this->get_field_id('title'); ?>">
			タイトル:
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</label></p>
		<fieldset>
			<legend>広告１</legend>
			<p><label for="<?php echo $this->get_field_id('adv1_url_1'); ?>">
				リンク先のURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv1_url_1'); ?>" name="<?php echo $this->get_field_name('adv1_url_1'); ?>" type="text" value="<?php echo $adv1_url_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv1_image_1'); ?>">
				画像ファイルのURL:
				<input class="widefat" id="<?php echo $this->get_field_id('adv1_image_1'); ?>" name="<?php echo $this->get_field_name('adv1_image_1'); ?>" type="text" value="<?php echo $adv1_image_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv1_name_1'); ?>">
				名前:
				<input class="widefat" id="<?php echo $this->get_field_id('adv1_name_1'); ?>" name="<?php echo $this->get_field_name('adv1_name_1'); ?>" type="text" value="<?php echo $adv1_name_1; ?>" />
			</label></p>
			<p><label for="<?php echo $this->get_field_id('adv1_text_1'); ?>">
				説明:
				<textarea class="widefat" id="<?php echo $this->get_field_id('adv1_text_1'); ?>" name="<?php echo $this->get_field_name('adv1_text_1'); ?>"><?php echo $adv1_text_1; ?></textarea>
			</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('adv1_target_1'); ?>" name="<?php echo $this->get_field_name('adv1_target_1'); ?>" value="1" <?php if( $adv1_target_1 ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('adv1_target_1'); ?>">別窓で開く</label></p>
		</fieldset>

		<?php
	}
}

add_action('widgets_init', create_function('', 'return register_widget("Banners_1");'));


/*-----------------------------------------------------------------------------------*/
/* テキスト（枠無し） */
/*-----------------------------------------------------------------------------------*/

class myd_text_noframe extends WP_Widget {
	function myd_text_noframe() {
		$widget_ops = array( 'description' => '枠無しのテキストウィジェット');
		$this->WP_Widget('myd_text_noframe', 'テキスト（枠無し）', $widget_ops);}

		function widget($args, $instance) {
			extract( $args );
				$title = apply_filters( 'widget_title', $instance['title'] );
				$body = apply_filters( 'widget_body', $instance['body'] );
			?>
			<div class="text_noframe">
			<?php
				echo $before_widget;
				if (!empty($title))
				echo $before_title . $title . $after_title;
				echo $body;
				echo $after_widget;
			?>
			</div>
			<?php
		}
		function update($new_instance, $old_instance) {
	$instance = $old_instance;
	$instance['title'] = strip_tags($new_instance['title']);
	$instance['body'] = trim($new_instance['body']);
			return $instance;
		}
		function form($instance) {
				$title = esc_attr($instance['title']);
				$body = esc_attr($instance['body']);
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>">
					タイトル:
				</label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<p>
				<textarea class="widefat" rows="16" colls="20" id="<?php echo $this->get_field_id('body'); ?>" name="<?php echo $this->get_field_name('body'); ?>"><?php echo $body; ?></textarea>
			</p>
			<?php
		}
}
add_action('widgets_init', create_function('', 'return register_widget("myd_text_noframe");'));


/*-----------------------------------------------------------------------------------*/
/* メタ情報 */
/*-----------------------------------------------------------------------------------*/

class WP_Widget_Meta_re extends WP_Widget {

	function WP_Widget_Meta_re() {
		$widget_ops = array('classname' => 'widget_meta widget-meta-re', 'description' => 'ログイン、管理画面、RSS フィード、WordPress へのリンク' );
		$this->WP_Widget('meta', 'メタ情報', $widget_ops);
	}

	function widget( $args, $instance ) {
		extract($args, EXTR_SKIP);
		$title = apply_filters('widget-title', empty($instance['title']) ? メタ情報 : $instance['title']);

		if ( $title )
			echo $before_widget;
			echo $before_title . $title . $after_title;
			?>
				<ul>
					<?php wp_register(); ?>
					<li><?php wp_loginout(); ?></li>
					<?php if ( $instance['postrss'] ) : ?>    <li><a href="<?php bloginfo('rss2_url'); ?>" title="Syndicate this site using RSS 2.0">投稿 <abbr title="Really Simple Syndication">RSS</abbr></a></li> <?php endif; ?>
					<?php if ( $instance['commentrss'] ) : ?> <li><a href="<?php bloginfo('comments_rss2_url'); ?>" title="The latest comments to all posts in RSS">コメント <abbr title="Really Simple Syndication">RSS</abbr></a></li> <?php endif; ?>
					<?php if ( $instance['wplink'] ) : ?>     <li><a href="http://wordpress.org/" title="Powered by WordPress, state-of-the-art semantic personal publishing platform.">WordPress.org</a></li> <?php endif; ?>
					<?php if ( $instance['wpjlink'] ) : ?>    <li><a href="http://ja.wordpress.org/" title="Powered by WordPress, state-of-the-art semantic personal publishing platform.">ja.WordPress.org</a></li> <?php endif; ?>
					<?php wp_meta(); ?>
				</ul>
			<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = esc_attr($new_instance['title']);
		$instance['postrss'] = (int) $new_instance['postrss'];
		$instance['commentrss'] = (int) $new_instance['commentrss'];
		$instance['wplink'] = (int) $new_instance['wplink'];
		$instance['wpjlink'] = (int) $new_instance['wpjlink'];
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
		$title = esc_attr($instance['title']);
		?>
			<p><label for="<?php echo $this->get_field_id('title'); ?>">タイトル</label>
				 <input type="text"     class="widefat"  id="<?php echo $this->get_field_id('title'); ?>"      name="<?php echo $this->get_field_name('title'); ?>"      value="<?php echo esc_attr($title); ?>" /></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('postrss'); ?>"    name="<?php echo $this->get_field_name('postrss'); ?>"    value="1" <?php if( $instance['postrss'] )    echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('postrss'); ?>">投稿の RSS を表示する</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('commentrss'); ?>" name="<?php echo $this->get_field_name('commentrss'); ?>" value="1" <?php if( $instance['commentrss'] ) echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('commentrss'); ?>">コメントの RSS を表示する</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('wplink'); ?>"     name="<?php echo $this->get_field_name('wplink'); ?>"     value="1" <?php if( $instance['wplink'] )     echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('wplink'); ?>">WordPress へのリンクを表示する</label></p>
			<p><input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('wpjlink'); ?>"    name="<?php echo $this->get_field_name('wpjlink'); ?>"    value="1" <?php if( $instance['wpjlink'] )    echo 'checked="checked"'; ?> /> <label for="<?php echo $this->get_field_id('wpjlink'); ?>">WordPress 日本語へのリンクを表示する</label></p>
		<?php
	}
}

function wp_widgets_init_re() {

	unregister_widget('WP_Widget_Meta');
	register_widget('WP_Widget_Meta_re');
}

add_action('widgets_init', 'wp_widgets_init_re');
