(function() {
	tinymce.PluginManager.add( 'ctw_parts_mce_button', function( editor, url ) {
		editor.addButton( 'ctw_parts_mce_button', {
			text: 'MMC用モジュール',
			type: 'menubutton',
			icon : false,
			menu: [


				/* ==========================================================================
					 メルマガ登録バナー
					 ========================================================================== */

				/* （サブメニューなし） */
				{
					text: 'メルマガ登録バナー',
					onclick: function() {
						editor.windowManager.open( {
							title: 'メルマガ登録バナーを挿入',
							body: [

							// バナーの種類
							{
								type: 'listbox',
								name: 'bannerDesing',
								label: 'バナーの種類',
								'values': [
									{text: 'デザイン1', value: '01'},
									{text: 'デザイン2', value: '02'}
								]
							},

							// バナーのサイズ
							{
								type: 'listbox',
								name: 'bannerSize',
								label: 'バナーのサイズ',
								'values': [
									{text: 'メインカラム用', value: 'main'},
									{text: 'サイドバー用', value: 'side'}
								]
							},

							// バナーの色
							{
								type: 'listbox',
								name: 'bannerColor',
								label: 'バナーの色',
								'values': [
									{text: 'ブルー', value: 'blue'},
									{text: 'レッド', value: 'red'}
								]
							},

							// URL
							{
								type: 'textbox',
								name: 'bannerUrl',
								label: 'URL',
								value: 'http://www.google.com/'
							},

							// ターゲット
							{
								type: 'listbox',
								name: 'bannerTarget',
								label: 'ターゲット',
								'values': [
									{text: '同じウィンドウ', value: '_self'},
									{text: '別のウィンドウ', value: '_blank'}
								]
							}],
							onsubmit: function( e ) {
								editor.insertContent( '<a class="ctw_optin_banner" href="' + e.data.bannerUrl + '" target="' + e.data.bannerTarget + '"><img src="[template_url]/ctw/img/induction' + e.data.bannerDesing + '_' + e.data.bannerSize + '_' + e.data.bannerColor + '_off.jpg" alt="ご登録はこちらをクリック" /></a>');
							}
						});
					}
				}, // メインカラム用バナー



				/* ==========================================================================
					 メルマガ登録フォーム
					 ========================================================================== */
				{
					text: 'メルマガ登録フォーム',
					menu: [

						/* CREAMAIL・マイスピー
							 ========================================================================== */
						{
							text: 'CREAMAIL・マイスピー',
							onclick: function() {
								editor.windowManager.open( {
									title: 'CREAMAIL・マイスピーを挿入',
									body: [

									// 入力項目
									{
										type: 'listbox',
										name: 'formInput',
										label: '入力項目',
										'values': [
											{text: 'メールアドレス', value: '<label for="Usermail"> メールアドレス </label><input type="text" name="data[User][mail]" id="Usermail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'},
											{text: 'お名前（姓）＋メールアドレス', value: '<label for="Username1"> お名前（苗字） </label><input type="text" name="data[User][name1]" id="Username1" value="" placeholder="姓" ime-mode="active" required="required" /><label for="Usermail"> メールアドレス </label><input type="text" name="data[User][mail]" id="Usermail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'}
										]
									},

									// メルマガID
									{
										type: 'textbox',
										name: 'formMagID',
										label: 'メルマガID',
										value: ''
									},

									// ドメイン
									{
										type: 'textbox',
										name: 'formDomain',
										label: 'ドメイン',
										value: ''
									},

									// タイトル
									{
										type: 'textbox',
										name: 'formTitle',
										label: 'タイトル',
										value: 'メールマガジン登録'
									},

									// 説明文
									{
										type: 'textbox',
										name: 'formDescription',
										label: '説明文',
										value: 'メールマガジン登録説明文。',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									},

									// 背景の色
									{
										type: 'textbox',
										name: 'formBgColor',
										label: '背景の色（#ffffff）',
										value: ''
									},

									// 囲みの色
									{
										type: 'textbox',
										name: 'formBorderColor',
										label: '囲みの色（#336699）',
										value: ''
									},

									// 囲みの太さ
									{
										type: 'textbox',
										name: 'formBorderWidth',
										label: '幅（1px）',
										value: ''
									},

									// 囲みの角丸
									{
										type: 'textbox',
										name: 'formBorderRadius',
										label: '囲みの角丸（4px）',
										value: ''
									},

									// 囲みの影
									{
										type: 'listbox',
										name: 'formBoxShadow',
										label: '囲みの影',
										'values': [
											{text: 'つける', value: ' ctw-form--box-shadow'},
											{text: 'つけない', value: ''}
										]
									},

									// ボタンの色
									{
										type: 'textbox',
										name: 'formBtnColor',
										label: 'ボタンの色（#339933）',
										value: ''
									},

									// ボタンの文字
									{
										type: 'textbox',
										name: 'formBtnText',
										label: 'ボタンの文字',
										value: '今すぐ無料で登録する！'
									}],

									onsubmit: function( e ) {
										editor.insertContent( '<div class="ctw-form ctw-form__unit' + e.data.formBoxShadow + ' " style="background-color: ' + e.data.formBgColor + '; border-color: ' + e.data.formBorderColor + '; border-width: ' + e.data.formBorderWidth + '; border-radius: ' + e.data.formBorderRadius + ';"><h3 class="ctw-form__title">' + e.data.formTitle + '</h3><p class="ctw-form__description">' + e.data.formDescription + '</p><form action="http://' + e.data.formDomain + '/p/r/' + e.data.formMagID + '" enctype="multipart/form-data" id="UserItemForm" method="post" accept-charset="utf-8" target="_blank" target="_blank">' + e.data.formInput + '<input type="hidden" name="_method" value="POST"/><input type="hidden" id="server_url" value="https://' + e.data.formDomain + '/"/><input type="hidden" name="data[User][referer_form_url]" value="http://' + e.data.formDomain + '/p/r/' + e.data.formMagID + '" id="UserRefererFormUrl"/><button type="submit" name="submit" value="send" class="hvr-buzz-out" style="background-color:' + e.data.formBtnColor + ';">' + e.data.formBtnText + '</button></form></div>' );
									}
								});
							}
						}, // CREAMAIL・マイスピー ここまで

						/* エキスパートメール
							 ========================================================================== */
						{
							text: 'エキスパートメール',
							onclick: function() {
								editor.windowManager.open( {
									title: 'エキスパートメールを挿入',
									body: [

									// 入力項目
									{
										type: 'listbox',
										name: 'formInput',
										label: '入力項目',
										'values': [
											{text: 'メールアドレス', value: '<label for="MasterSubscriberMail">メールアドレス</label><input type="text" name="Mail" id="MasterSubscriberMail" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'},
											{text: 'お名前（姓）＋メールアドレス', value: '<label for="MasterSubscriberNameAll">お名前（苗字）</label><input type="text" name="NameAll" id="MasterSubscriberNameAll" placeholder="姓" ime-mode="active" required="required" /><label for="MasterSubscriberMail">メールアドレス</label><input type="text" name="Mail" id="MasterSubscriberMail" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'}
										]
									},

									// フォームコード
									{
										type: 'textbox',
										name: 'formFormCd',
										label: 'フォームコード',
										value: ''
									},

									// 契約者ID
									{
										type: 'textbox',
										name: 'formPubid',
										label: '契約者ID',
										value: ''
									},

									// ドメイン
									{
										type: 'textbox',
										name: 'formDomain',
										label: 'ドメイン',
										value: ''
									},

									// タイトル
									{
										type: 'textbox',
										name: 'formTitle',
										label: 'タイトル',
										value: 'メールマガジン登録'
									},

									// 説明文
									{
										type: 'textbox',
										name: 'formDescription',
										label: '説明文',
										value: 'メールマガジン登録説明文。',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									},

									// 背景の色
									{
										type: 'textbox',
										name: 'formBgColor',
										label: '背景の色（#ffffff）',
										value: ''
									},

									// 囲みの色
									{
										type: 'textbox',
										name: 'formBorderColor',
										label: '囲みの色（#336699）',
										value: ''
									},

									// 囲みの太さ
									{
										type: 'textbox',
										name: 'formBorderWidth',
										label: '幅（1px）',
										value: ''
									},

									// 囲みの角丸
									{
										type: 'textbox',
										name: 'formBorderRadius',
										label: '囲みの角丸（4px）',
										value: ''
									},

									// 囲みの影
									{
										type: 'listbox',
										name: 'formBoxShadow',
										label: '囲みの影',
										'values': [
											{text: 'つける', value: ' ctw-form--box-shadow'},
											{text: 'つけない', value: ''}
										]
									},

									// ボタンの色
									{
										type: 'textbox',
										name: 'formBtnColor',
										label: 'ボタンの色（#339933）',
										value: ''
									},

									// ボタンの文字
									{
										type: 'textbox',
										name: 'formBtnText',
										label: 'ボタンの文字',
										value: '今すぐ無料で登録する！'
									}],

									onsubmit: function( e ) {
										editor.insertContent( '<div class="ctw-form ctw-form__unit' + e.data.formBoxShadow + ' " style="background-color: ' + e.data.formBgColor + '; border-color: ' + e.data.formBorderColor + '; border-width: ' + e.data.formBorderWidth + '; border-radius: ' + e.data.formBorderRadius + ';"><h3 class="ctw-form__title">' + e.data.formTitle + '</h3><p class="ctw-form__description">' + e.data.formDescription + '</p><form action="https://' + e.data.formDomain + '" id="FormIndexForm" method="post" accept-charset="utf-8" target="_blank">' + e.data.formInput + '<input type="hidden" name="_method" value="POST"/><input type="hidden" name="Form_Cd" value="' + e.data.formFormCd + '" id="MasterSubscriberPublisherId"/><input type="hidden" name="Publisher_Id" value="' + e.data.formPubid + '" id="MasterSubscriberInputNo"/><button type="submit" name="exec" value="send" class="hvr-buzz-out" style="background-color:' + e.data.formBtnColor + ';">' + e.data.formBtnText + '</button></form></div>' );
									}
								});
							}
						}, // エキスパートメール ここまで

						/* アスメル
							 ========================================================================== */
						{
							text: 'アスメル',
							onclick: function() {
								editor.windowManager.open( {
									title: 'アスメルを挿入',
									body: [

									// 入力項目
									{
										type: 'listbox',
										name: 'formInput',
										label: '入力項目',
										'values': [
											{text: 'メールアドレス', value: '<label for="touroku_mail">メールアドレス</label><input type="text" name="touroku_mail" id="touroku_mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'},
											{text: 'お名前（姓）＋メールアドレス', value: '<label for="touroku_name">お名前（苗字）</label><input type="text" name="touroku_name" id="touroku_name" value="" placeholder="姓" ime-mode="active" required="required" /><label for="touroku_mail">メールアドレス</label><input type="text" name="touroku_mail" id="touroku_mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'}
										]
									},

									// メルマガID
									{
										type: 'textbox',
										name: 'formMagID',
										label: 'メルマガID',
										value: ''
									},

									// タイトル
									{
										type: 'textbox',
										name: 'formTitle',
										label: 'タイトル',
										value: 'メールマガジン登録'
									},

									// 説明文
									{
										type: 'textbox',
										name: 'formDescription',
										label: '説明文',
										value: 'メールマガジン登録説明文。',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									},

									// 背景の色
									{
										type: 'textbox',
										name: 'formBgColor',
										label: '背景の色（#ffffff）',
										value: ''
									},

									// 囲みの色
									{
										type: 'textbox',
										name: 'formBorderColor',
										label: '囲みの色（#336699）',
										value: ''
									},

									// 囲みの太さ
									{
										type: 'textbox',
										name: 'formBorderWidth',
										label: '幅（1px）',
										value: ''
									},

									// 囲みの角丸
									{
										type: 'textbox',
										name: 'formBorderRadius',
										label: '囲みの角丸（4px）',
										value: ''
									},

									// 囲みの影
									{
										type: 'listbox',
										name: 'formBoxShadow',
										label: '囲みの影',
										'values': [
											{text: 'つける', value: ' ctw-form--box-shadow'},
											{text: 'つけない', value: ''}
										]
									},

									// ボタンの色
									{
										type: 'textbox',
										name: 'formBtnColor',
										label: 'ボタンの色（#339933）',
										value: ''
									},

									// ボタンの文字
									{
										type: 'textbox',
										name: 'formBtnText',
										label: 'ボタンの文字',
										value: '今すぐ無料で登録する！'
									}],

									onsubmit: function( e ) {
										editor.insertContent( '<div class="ctw-form ctw-form__unit' + e.data.formBoxShadow + ' " style="background-color: ' + e.data.formBgColor + '; border-color: ' + e.data.formBorderColor + '; border-width: ' + e.data.formBorderWidth + '; border-radius: ' + e.data.formBorderRadius + ';"><h3 class="ctw-form__title">' + e.data.formTitle + '</h3><p class="ctw-form__description">' + e.data.formDescription + '</p><form name="asumeru_form" method="post" action="https://1lejend.com/stepmail/kd.php?no=' + e.data.formMagID + '" target="_blank">' + e.data.formInput + '<input type="hidden" name="no" value="' + e.data.formMagID + '"><input type="hidden" name="action" value="kakunin" /><button type="submit" name="submit" value="send" class="hvr-buzz-out" style="background-color:' + e.data.formBtnColor + ';">' + e.data.formBtnText + '</button></form></div>' );
									}
								});
							}
						}, // アスメル ここまで


						/* オレンジメール
							 ========================================================================== */
						{
							text: 'オレンジメール',
							onclick: function() {
								editor.windowManager.open( {
									title: 'オレンジメールを挿入',
									body: [

									// 入力項目
									{
										type: 'listbox',
										name: 'formInput',
										label: '入力項目',
										'values': [
											{text: 'メールアドレス', value: '<label for="mail">メールアドレス</label><input type="text" name="mail" id="mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'},
											{text: 'お名前（姓）＋メールアドレス', value: '<label for="free1">お名前</label><input type="text" name="free1" id="free1" value="" placeholder="姓" ime-mode="active" required="required" /><label for="mail">メールアドレス</label><input type="text" name="mail" id="mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />'}
										]
									},

									// メルマガID
									{
										type: 'textbox',
										name: 'formMagID',
										label: 'メルマガID',
										value: ''
									},

									// タイトル
									{
										type: 'textbox',
										name: 'formTitle',
										label: 'タイトル',
										value: 'メールマガジン登録'
									},

									// 説明文
									{
										type: 'textbox',
										name: 'formDescription',
										label: '説明文',
										value: 'メールマガジン登録説明文。',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									},

									// 背景の色
									{
										type: 'textbox',
										name: 'formBgColor',
										label: '背景の色（#ffffff）',
										value: ''
									},

									// 囲みの色
									{
										type: 'textbox',
										name: 'formBorderColor',
										label: '囲みの色（#336699）',
										value: ''
									},

									// 囲みの太さ
									{
										type: 'textbox',
										name: 'formBorderWidth',
										label: '幅（1px）',
										value: ''
									},

									// 囲みの角丸
									{
										type: 'textbox',
										name: 'formBorderRadius',
										label: '囲みの角丸（4px）',
										value: ''
									},

									// 囲みの影
									{
										type: 'listbox',
										name: 'formBoxShadow',
										label: '囲みの影',
										'values': [
											{text: 'つける', value: ' ctw-form--box-shadow'},
											{text: 'つけない', value: ''}
										]
									},

									// ボタンの色
									{
										type: 'textbox',
										name: 'formBtnColor',
										label: 'ボタンの色（#339933）',
										value: ''
									},

									// ボタンの文字
									{
										type: 'textbox',
										name: 'formBtnText',
										label: 'ボタンの文字',
										value: '今すぐ無料で登録する！'
									}],

									onsubmit: function( e ) {
										editor.insertContent( '<div class="ctw-form ctw-form__unit' + e.data.formBoxShadow + ' " style="background-color: ' + e.data.formBgColor + '; border-color: ' + e.data.formBorderColor + '; border-width: ' + e.data.formBorderWidth + '; border-radius: ' + e.data.formBorderRadius + ';"><h3 class="ctw-form__title">' + e.data.formTitle + '</h3><p class="ctw-form__description">' + e.data.formDescription + '</p><form action="http://form.os7.biz/form/submit" method="post" id="OF_form1" target="_blank"><p id="announce"><span class="error"></span></p>' + e.data.formInput + '<input type="hidden" name="form_id" value="' + e.data.formMagID + '" /><input type="hidden" name="encoding_test" value="あいうえお眉幅ABC" /><!-- [S110801-03] ins start --><input type="hidden" name="base_url" id="base_url" value="http://form.os7.biz/" /><input type="hidden" name="urlhash" id="urlhash" value="f/de3c2573/" /><!-- [S110801-03] ins end --><button type="submit" name="submit" value="send" class="hvr-buzz-out" style="background-color:' + e.data.formBtnColor + ';">' + e.data.formBtnText + '</button></form></div>' );
									}
								});
							}
						}, // オレンジメール ここまで

					]
				}, // 「フォーム」セクション ここまで



				/* ==========================================================================
					 ワイド見出し
					 ========================================================================== */

				/* （サブメニューなし） */
				{
					text: 'ワイド見出し',
					onclick: function() {
						editor.windowManager.open( {
							title: 'ワイド見出しを挿入',
							body: [

							// 背景の色
							{
								type: 'textbox',
								name: 'headerBgColor',
								label: '背景の色（#cc0033）',
								value: ''
							},

							// 文字の色
							{
								type: 'textbox',
								name: 'headerTextColor',
								label: '文字の色（#ffff99）',
								value: ''
							},

							// 文字の大きさ
							{
								type: 'textbox',
								name: 'headerTextSize',
								label: '文字の大きさ（33px）',
								value: ''
							},

							// 見出しの文字
							{
								type: 'textbox',
								name: 'headerText',
								label: '見出しの文字',
								value: ''
							}],
							onsubmit: function( e ) {
								editor.insertContent( '<div class="ctw-wide-header" style="background-color:' + e.data.headerBgColor + '; color:' + e.data.headerTextColor + '; font-size:' + e.data.headerTextSize + '; ">' + e.data.headerText + '</div>');
							}
						});
					}
				}, // ワイド見出し



				/* ==========================================================================
					 1カラム用ヘッダーバナー
					 ========================================================================== */

				/* （サブメニューなし） */
				{
					text: '1カラム用ヘッダーバナー',
					onclick: function() {
						editor.windowManager.open( {
							title: '1カラム用ヘッダーバナーを挿入',
							body: [

							// 画像のURL
							{
								type: 'textbox',
								name: 'imageUrl',
								label: '画像のURL',
								value: ''
							}],
							onsubmit: function( e ) {
								editor.insertContent( '<div class="ctw-header-image--c1"><img src="' + e.data.imageUrl + '" /></div>');
							}
						});
					}
				}, // 1カラム用ヘッダーバナー



				/* ==========================================================================
					 特典の説明
					 ========================================================================== */
				{
					text: '特典の説明',
					menu: [

						/* 見出し
							 ========================================================================== */
						{
							text: '見出し',
							onclick: function() {
								editor.windowManager.open( {
									title: '見出しを挿入',
									body: [

									// 特典の番号
									{
										type: 'listbox',
										name: 'bonusNumber',
										label: '特典の番号',
										'values': [
											{text: '番号なし', value: 'n'},
											{text: '特典1', value: '1'},
											{text: '特典2', value: '2'},
											{text: '特典3', value: '3'},
											{text: '特典4', value: '4'},
											{text: '特典5', value: '5'},
											{text: '特典6', value: '6'},
											{text: '特典7', value: '7'},
											{text: '特典8', value: '8'},
											{text: '特典9', value: '9'},
											{text: '特典10', value: '10'}
										]
									},

									// バッジの種類
									{
										type: 'listbox',
										name: 'bonusDesing',
										label: 'バッジの種類',
										'values': [
											{text: 'デザイン1', value: 'a'},
											{text: 'デザイン2', value: 'b'}
										]
									},

									// バッジの色
									{
										type: 'listbox',
										name: 'bonusColor',
										label: 'バッジの色',
										'values': [
											{text: 'ブルー', value: 'blu'},
											{text: 'レッド', value: 'red'}
										]
									},

									// 見出し
									{
										type: 'textbox',
										name: 'bonusHead',
										label: '見出し',
										value: '特典見出し'
									}],

									onsubmit: function( e ) {
										editor.insertContent( '<div class="ctw-bonus__head ctw-bbh-' + e.data.bonusDesing + ' ctw-bbh-' + e.data.bonusColor + ' ctw-bbh-' + e.data.bonusNumber + '">' + e.data.bonusHead + '</div>' );
									}
								});
							}
						}, // 見出し ここまで

						/* 囲み
							 ========================================================================== */
						{
							text: '囲み',
							onclick: function() {
								editor.windowManager.open( {
									title: '囲みを挿入',
									body: [

									// 特典の番号
									{
										type: 'listbox',
										name: 'bonusNumber',
										label: '特典の番号',
										'values': [
											{text: '番号なし', value: 'n'},
											{text: '特典1', value: '1'},
											{text: '特典2', value: '2'},
											{text: '特典3', value: '3'},
											{text: '特典4', value: '4'},
											{text: '特典5', value: '5'},
											{text: '特典6', value: '6'},
											{text: '特典7', value: '7'},
											{text: '特典8', value: '8'},
											{text: '特典9', value: '9'},
											{text: '特典10', value: '10'}
										]
									},

									// バッジの種類
									{
										type: 'listbox',
										name: 'bonusDesing',
										label: 'バッジの種類',
										'values': [
											{text: 'デザイン1', value: 'a'},
											{text: 'デザイン2', value: 'b'}
										]
									},

									// バッジの色
									{
										type: 'listbox',
										name: 'bonusColor',
										label: 'バッジの色',
										'values': [
											{text: 'ブルー', value: 'blu'},
											{text: 'レッド', value: 'red'}
										]
									},

									// 見出し
									{
										type: 'textbox',
										name: 'bonusHead',
										label: '見出し',
										value: '特典見出し'
									},

									// 特典の内容
									{
										type: 'textbox',
										name: 'bonusDescription',
										label: '特典の内容',
										value: '',
										multiline: true,
										minWidth: 300,
										minHeight: 100
									}],

									onsubmit: function( e ) {
										editor.insertContent( '<div class="ctw-bonus__box"><h4 class="ctw-bonus__box__head ctw-bbh-' + e.data.bonusDesing + ' ctw-bbh-' + e.data.bonusColor + ' ctw-bbh-' + e.data.bonusNumber + '">' + e.data.bonusHead + '</h4>' + e.data.bonusDescription + '</div>' );
									}
								});
							}
						}, // 囲み ここまで

					]
				}, // 「特典説明」セクション ここまで




			]
		});
	});
})();