<?php
/**
 * Widgets for Catch the web
 *
 * これを見て作った
 * http://liginc.co.jp/web/wp/112370
 *
 */

/*-----------------------------------------------------------------------------------*/
/* CTW バナー */
/*-----------------------------------------------------------------------------------*/

class ctw_optin_banner extends WP_Widget{
	/**
	 * Widgetを登録する
	 */
	function __construct() {
		parent::__construct(
			'ctw_optin_banner', // Base ID
			'メルマガ登録バナー', // Name
			array( 'description' => 'メルマガ登録バナーの説明', ) // Args
		);
	}
 
	/**
	 * 表側の Widget を出力する
	 *
	 * @param array $args      'register_sidebar'で設定した「before_title, after_title, before_widget, after_widget」が入る
	 * @param array $instance  Widgetの設定項目
	 */
	public function widget( $args, $instance ) {
		$url = $instance['url'];
		$target = $instance['target'];
		$design = $instance['design'];
		$size = $instance['size'];
		$color = $instance['color'];
		?>
		<a class="ctw_optin_banner" href="<?php echo $url; ?>" <?php if($target=='1') : ?>target="_blank"<?php endif; ?> ><img src="<?php echo get_bloginfo('template_url')?>/ctw/img/induction<?php echo $design; ?>_<?php echo $size; ?>_<?php echo $color; ?>_off.jpg" alt="ご登録はこちらをクリック" /></a>
		<?php
	}
 
	/** Widget管理画面を出力する
	 *
	 * @param array $instance 設定項目
	 * @return string|void
	 */
	public function form( $instance ){
		$design = $instance['design'];
		$size = $instance['size'];
		$color = $instance['color'];
		$url = $instance['url'];
		$target = $instance['target'];
		?>
		<p>
			<label for="<?php echo $this->get_field_id('design'); ?>">デザイン:</label>
			<select class="widefat" id="<?php echo $this->get_field_id('design'); ?>" name="<?php echo $this->get_field_name('design'); ?>">
				<option value="01"<?php selected( $instance['design'], "01" ); ?>>デザイン1</option>
				<option value="02"<?php selected( $instance['design'], "02" ); ?>>デザイン2</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('size'); ?>">サイズ:</label>
			<select class="widefat" id="<?php echo $this->get_field_id('size'); ?>" name="<?php echo $this->get_field_name('size'); ?>">
				<option value="main"<?php selected( $instance['size'], "main" ); ?>>メインカラム用</option>
				<option value="side"<?php selected( $instance['size'], "side" ); ?>>サイドバー用</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('color'); ?>">カラー:</label>
			<select class="widefat" id="<?php echo $this->get_field_id('color'); ?>" name="<?php echo $this->get_field_name('color'); ?>">
				<option value="blue"<?php selected( $instance['color'], "blue" ); ?>>ブルー</option>
				<option value="red"<?php selected( $instance['color'], "red" ); ?>>レッド</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('url'); ?>">リンクURL:</label>
			<input class="widefat" id="<?php echo $this->get_field_id('url'); ?>" name="<?php echo $this->get_field_name('url'); ?>" type="text" value="<?php echo esc_attr( $url ); ?>">
		</p>

		<p>
			<input class="checkbox" id="<?php echo $this->get_field_id('target'); ?>" name="<?php echo $this->get_field_name('target'); ?>" type="checkbox" value="1" <?php if( $target ) echo 'checked="checked"'; ?> />
			<label for="<?php echo $this->get_field_id('target'); ?>">別窓で開く</label>
		</p>

		<?php
	}
 
	/** 新しい設定データが適切なデータかどうかをチェックする。
	 * 必ず$instanceを返す。さもなければ設定データは保存（更新）されない。
	 *
	 * @param array $new_instance  form()から入力された新しい設定データ
	 * @param array $old_instance  前回の設定データ
	 * @return array               保存（更新）する設定データ。falseを返すと更新しない。
	 */
  function update( $new_instance, $old_instance ) {
	$instance = $old_instance;
	$instance['design'] = $new_instance['design'];
	$instance['size'] = $new_instance['size'];
	$instance['color'] = $new_instance['color'];
	$instance['url'] = $new_instance['url'];
	$instance['target'] = $new_instance['target'];
	return $new_instance;
  }
}
 
add_action( 'widgets_init', function () {
	register_widget( 'ctw_optin_banner' );  //WidgetをWordPressに登録する
} );

/*-----------------------------------------------------------------------------------*/
/* CTW フォーム */
/*-----------------------------------------------------------------------------------*/

class ctw_optin_form extends WP_Widget{
	/**
	 * Widgetを登録する
	 */
	function __construct() {
		parent::__construct(
			'ctw_optin_form', // Base ID
			'メルマガ登録フォーム', // Name
			array( 'description' => 'メルマガ登録フォームの説明', ) // Args
		);
	}
 
	/**
	 * 表側の Widget を出力する
	 *
	 * @param array $args      'register_sidebar'で設定した「before_title, after_title, before_widget, after_widget」が入る
	 * @param array $instance  Widgetの設定項目
	 */
	public function widget( $args, $instance ) {
		$stand = $instance['stand'];
		$input = $instance['input'];
		$magid = $instance['magid'];
		$pubid = $instance['pubid'];
		$domain = $instance['domain'];

		$title = $instance['title'];
		$description = $instance['description'];
		$background_color = $instance['background_color'];
		$border_color = $instance['border_color'];
		$border_width = $instance['border_width'];
		$box_shadow = $instance['box_shadow'];
		$button_color = $instance['button_color'];
		$button_text = $instance['button_text'];

		// echo $args['before_widget'];
		?>

		<?php if($stand=='stand01') : ?>
			<!-- CREAMAIL・マイスピー -->
			<aside class="ctw-form ctw-form__unit<?php if($box_shadow=='1') : ?> ctw-form--box-shadow<?php endif; ?>" style="background-color: <?php echo $instance['background_color']; ?>; border-color: <?php echo $instance['border_color']; ?>; border-width: <?php echo $instance['border_width']; ?>; border-radius: <?php echo $instance['border_radius']; ?>;">
				<h3 class="ctw-form__title" style="background-color: <?php echo $instance['border_color']; ?>"><?php if($instance['title'] == NULL ){ echo 'メールマガジン登録';} else { echo '' . $instance['title'] . '';} ?></h3>
				<?php if($instance['description'] == NULL ){ echo "";} else { echo '<div class="ctw-form__description">' . $instance['description'] . '</div>';} ?>
				<form action="https://<?php echo $instance['domain']; ?>/p/r/<?php echo $instance['magid']; ?>" enctype="multipart/form-data" id="UserItemForm" method="post" accept-charset="utf-8" target="_blank" target="_blank">
					<?php if($input=='mail') : ?>
						<label for="Usermail"> メールアドレス</label>
						<input type="text" name="data[User][mail]" id="Usermail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php else : ?>
						<label for="Username1"> お名前（苗字）</label>
						<input type="text" name="data[User][name1]" id="Username1" value="" placeholder="姓" ime-mode="active" required="required" />
						<label for="Usermail"> メールアドレス </label>
						<input type="text" name="data[User][mail]" id="Usermail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php endif; ?>
						<input type="hidden" name="_method" value="POST"/>
						<input type="hidden" id="server_url" value="https://<?php echo $instance['domain']; ?>/"/>
						<input type="hidden" name="data[User][referer_form_url]" value="http://<?php echo $instance['domain']; ?>/p/r/<?php echo $instance['magid']; ?>" id="UserRefererFormUrl"/>
						<button type='submit' name='action' value='send' class="hvr-buzz-out" style="background-color: <?php echo $instance['button_color']; ?>;"><?php if($instance['button_text'] == NULL ){ echo "今すぐ無料で登録する";} else { echo  $instance['button_text'] ;} ?></button>
				</form>
			</aside>
			<!-- /CREAMAIL・マイスピー -->

		<?php elseif($stand=='stand02') : ?>
			<!-- エキスパートメール -->
			<aside class="ctw-form ctw-form__unit<?php if($box_shadow=='1') : ?> ctw-form--box-shadow<?php endif; ?>" style="background-color: <?php echo $instance['background_color']; ?>; border-color: <?php echo $instance['border_color']; ?>; border-width: <?php echo $instance['border_width']; ?>; border-radius: <?php echo $instance['border_radius']; ?>;">
				<h3 class="ctw-form__title" style="background-color: <?php echo $instance['border_color']; ?>"><?php if($instance['title'] == NULL ){ echo 'メールマガジン登録';} else { echo '' . $instance['title'] . '';} ?></h3>
				<?php if($instance['description'] == NULL ){ echo "";} else { echo '<div class="ctw-form__description">' . $instance['description'] . '</div>';} ?>
				<form action="https://<?php echo $instance['domain']; ?>" id="FormIndexForm" method="post" accept-charset="utf-8" target="_blank">
					<?php if($input=='mail') : ?>
						<label for="MasterSubscriberMail">メールアドレス</label>
						<input type="text" name="Mail" id="MasterSubscriberMail" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php else : ?>
						<label for="MasterSubscriberNameAll">お名前（苗字）</label>
						<input type="text" name="NameAll" id="MasterSubscriberNameAll" placeholder="姓" ime-mode="active" required="required" />
						<label for="MasterSubscriberMail">メールアドレス</label>
						<input type="text" name="Mail" id="MasterSubscriberMail" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php endif; ?>
						<input type="hidden" name="_method" value="POST"/>
						<input type="hidden" name="Publisher_Id" value="<?php echo $instance['pubid']; ?>" id="MasterSubscriberPublisherId"/>
						<input type="hidden" name="Form_Cd" value="<?php echo $instance['magid']; ?>" id="MasterSubscriberInputNo"/>
						<button type='submit' name='exec' value='send' class="hvr-buzz-out" style="background-color: <?php echo $instance['button_color']; ?>;"><?php if($instance['button_text'] == NULL ){ echo "今すぐ無料で登録する";} else { echo  $instance['button_text'] ;} ?></button>
				</form>
			</aside>
			<!-- /エキスパートメール -->

		<?php elseif($stand=='stand03') : ?>
			<!-- アスメル -->
			<aside class="ctw-form ctw-form__unit<?php if($box_shadow=='1') : ?> ctw-form--box-shadow<?php endif; ?>" style="background-color: <?php echo $instance['background_color']; ?>; border-color: <?php echo $instance['border_color']; ?>; border-width: <?php echo $instance['border_width']; ?>; border-radius: <?php echo $instance['border_radius']; ?>;">
				<h3 class="ctw-form__title" style="background-color: <?php echo $instance['border_color']; ?>"><?php if($instance['title'] == NULL ){ echo 'メールマガジン登録';} else { echo '' . $instance['title'] . '';} ?></h3>
				<?php if($instance['description'] == NULL ){ echo "";} else { echo '<div class="ctw-form__description">' . $instance['description'] . '</div>';} ?>
				<form name="asumeru_form" method="post" action="https://1lejend.com/stepmail/kd.php?no=<?php echo $instance['magid']; ?>" target="_blank">
					<?php if($input=='mail') : ?>
						<label for="touroku_mail">メールアドレス</label>
						<input type="text" name="touroku_mail" id="touroku_mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php else : ?>
						<label for="touroku_name">お名前（苗字）</label>
						<input type="text" name="touroku_name" id="touroku_name" value="" placeholder="姓" ime-mode="active" required="required" />
						<label for="touroku_mail">メールアドレス</label>
						<input type="text" name="touroku_mail" id="touroku_mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php endif; ?>
						<input type="hidden" name="no" value="<?php echo $instance['magid']; ?>">
						<input type="hidden" name="action" value="kakunin" />
						<button type='submit' name='submit' value='send' class="hvr-buzz-out" style="background-color: <?php echo $instance['button_color']; ?>;"><?php if($instance['button_text'] == NULL ){ echo "今すぐ無料で登録する";} else { echo  $instance['button_text'] ;} ?></button>
				</form>
			</aside>
			<!-- /アスメル -->

		<?php elseif($stand=='stand04') : ?>
			<!-- オレンジメール -->
			<aside class="ctw-form ctw-form__unit<?php if($box_shadow=='1') : ?> ctw-form--box-shadow<?php endif; ?>" style="background-color: <?php echo $instance['background_color']; ?>; border-color: <?php echo $instance['border_color']; ?>; border-width: <?php echo $instance['border_width']; ?>; border-radius: <?php echo $instance['border_radius']; ?>;">
				<h3 class="ctw-form__title" style="background-color: <?php echo $instance['border_color']; ?>"><?php if($instance['title'] == NULL ){ echo 'メールマガジン登録';} else { echo '' . $instance['title'] . '';} ?></h3>
				<?php if($instance['description'] == NULL ){ echo "";} else { echo '<div class="ctw-form__description">' . $instance['description'] . '</div>';} ?>
				<form action="http://form.os7.biz/form/submit" method="post" id="OF_form1" target="_blank">
					<p id="announce"><span class="error"></span></p>
					<?php if($input=='mail') : ?>
						<label for="mail">メールアドレス</label>
						<input type="text" name="mail" id="mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php else : ?>
						<label for="free1">お名前（苗字）</label>
						<input type="text" name="free1" id="free1" value="" placeholder="姓" ime-mode="active" required="required" />
						<label for="mail">メールアドレス</label>
						<input type="text" name="mail" id="mail" value="" placeholder="＠を含んだ形式で、半角でご入力ください" ime-mode="disabled" required="required" />
					<?php endif; ?>
						<input type="hidden" name="form_id" value="<?php echo $instance['magid']; ?>" />
						<input type="hidden" name="encoding_test" value="あいうえお眉幅ABC" />
						<!-- [S110801-03] ins start -->
						<input type="hidden" name="base_url" id="base_url" value="http://form.os7.biz/" />
						<input type="hidden" name="urlhash" id="urlhash" value="f/de3c2573/" />
						<!-- [S110801-03] ins end -->
						<button type='submit' name='submit' value='send' class="hvr-buzz-out" style="background-color: <?php echo $instance['button_color']; ?>;"><?php if($instance['button_text'] == NULL ){ echo "今すぐ無料で登録する";} else { echo  $instance['button_text'] ;} ?></button>
				</form>
			</aside>
			<!-- /オレンジメール -->

		<?php else : ?>
		<?php endif; ?>
		<?php

		// echo $args['after_widget'];
	}
 
	/** Widget管理画面を出力する
	 *
	 * @param array $instance 設定項目
	 * @return string|void
	 */
	public function form( $instance ){
		$stand = $instance['stand'];
		$input = $instance['input'];
		$magid = esc_attr( $instance['magid'] );
		$pubid = esc_attr( $instance['pubid'] );
		$domain = esc_attr( $instance['domain'] );

		$title = esc_attr( $instance['title'] );
		$description = esc_attr( $instance['description'] );
		$background_color = esc_attr( $instance['background_color'] );
		$border_color = esc_attr( $instance['border_color'] );
		$border_width = esc_attr( $instance['border_width'] );
		$border_radius = esc_attr( $instance['border_radius'] );
		$box_shadow = $instance['box_shadow'];
		$button_color = esc_attr( $instance['button_color'] );
		$button_text = esc_attr( $instance['button_text'] );
		?>

		<fieldset>
			<legend>メルマガ設定</legend>
			<p>
				<label for="<?php echo $this->get_field_id('stand'); ?>">配信スタンド:</label>
				<select class="widefat" id="<?php echo $this->get_field_id('stand'); ?>" name="<?php echo $this->get_field_name('stand'); ?>">
				<option value="stand01"<?php selected( $instance['stand'], "stand01" ); ?>>CREAMAIL・マイスピー</option>
				<option value="stand02"<?php selected( $instance['stand'], "stand02" ); ?>>エキスパートメール</option>
				<option value="stand03"<?php selected( $instance['stand'], "stand03" ); ?>>アスメル</option>
				<option value="stand04"<?php selected( $instance['stand'], "stand04" ); ?>>オレンジメール</option>
			  </select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('input'); ?>">入力項目:</label>
				<select class="widefat" id="<?php echo $this->get_field_id('input'); ?>" name="<?php echo $this->get_field_name('input'); ?>">
				<option value="mail"<?php selected( $instance["input"], "mail" ); ?>>メールアドレスのみ</option>
				<option value="mail_name"<?php selected( $instance["input"], "mail_name" ); ?>>お名前（苗字）＋メールアドレス</option>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('magid'); ?>">メルマガID／フォームコード:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('magid'); ?>" name="<?php echo $this->get_field_name('magid'); ?>" type="text" value="<?php echo esc_attr( $magid ); ?>">
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('domain'); ?>">ドメイン:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('domain'); ?>" name="<?php echo $this->get_field_name('domain'); ?>" type="text" value="<?php echo esc_attr( $domain ); ?>">
				※ CREAMAIL・マイスピー、エキスパートメールをご利用の方のみ。<br />
				※ http://、https:// は含めないでください。
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('pubid'); ?>">契約者ID:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('pubid'); ?>" name="<?php echo $this->get_field_name('pubid'); ?>" type="text" value="<?php echo esc_attr( $pubid ); ?>">
				※ エキスパートメールをご利用の方のみ。
			</p>
		</fieldset>

		<fieldset>
			<legend>デザイン設定</legend>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>">タイトル:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('description'); ?>">説明文:</label>
				<textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_attr( $description ); ?></textarea>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('background_color'); ?>">背景の色（例：#eeeeee）:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('background_color'); ?>" name="<?php echo $this->get_field_name('background_color'); ?>" type="text" value="<?php echo esc_attr( $background_color ); ?>">
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('border_color'); ?>">囲みの色（例：#336699）:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('border_color'); ?>" name="<?php echo $this->get_field_name('border_color'); ?>" type="text" value="<?php echo esc_attr( $border_color ); ?>">
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('border_width'); ?>">囲みの太さ（例：1px）:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('border_width'); ?>" name="<?php echo $this->get_field_name('border_width'); ?>" type="text" value="<?php echo esc_attr( $border_width ); ?>">
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('border_radius'); ?>">囲みの角丸（例：5px）:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('border_radius'); ?>" name="<?php echo $this->get_field_name('border_radius'); ?>" type="text" value="<?php echo esc_attr( $border_radius ); ?>">
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('box_shadow'); ?>">囲みの影:</label>
				<select class="widefat" id="<?php echo $this->get_field_id('box_shadow'); ?>" name="<?php echo $this->get_field_name('box_shadow'); ?>">
				<option value="0"<?php selected( $instance["box_shadow"], "0" ); ?>>つけない</option>
				<option value="1"<?php selected( $instance["box_shadow"], "1" ); ?>>つける</option>
				</select>
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('button_color'); ?>">ボタンの色（例：#336699）:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('button_color'); ?>" name="<?php echo $this->get_field_name('button_color'); ?>" type="text" value="<?php echo esc_attr( $button_color ); ?>">
			</p>

			<p>
				<label for="<?php echo $this->get_field_id('button_text'); ?>">ボタンの文字:</label>
				<input class="widefat" id="<?php echo $this->get_field_id('button_text'); ?>" name="<?php echo $this->get_field_name('button_text'); ?>" type="text" value="<?php echo esc_attr( $button_text ); ?>">
			</p>
		</fieldset>
		<?php
	}

	/** 新しい設定データが適切なデータかどうかをチェックする。
	 * 必ず$instanceを返す。さもなければ設定データは保存（更新）されない。
	 *
	 * @param array $new_instance  form()から入力された新しい設定データ
	 * @param array $old_instance  前回の設定データ
	 * @return array               保存（更新）する設定データ。falseを返すと更新しない。
	 */
  function update( $new_instance, $old_instance ) {
	$instance = $old_instance;
	$instance['stand'] = $new_instance['stand'];
	$instance['input'] = $new_instance['input'];
	$instance['magid'] = $new_instance['magid'];
	$instance['pubid'] = $new_instance['pubid'];
	$instance['domain'] = $new_instance['domain'];

	$instance['title'] = $new_instance['title'];
	$instance['description'] = $new_instance['description'];
	$instance['background_color'] = $new_instance['background_color'];
	$instance['border_color'] = $new_instance['border_color'];
	$instance['border_width'] = $new_instance['border_width'];
	$instance['border_radius'] = $new_instance['border_width'];
	$instance['box_shadow'] = $new_instance['box_shadow'];
	$instance['button_color'] = $new_instance['button_color'];
	$instance['button_text'] = $new_instance['button_text'];
		return $new_instance;
	}
}
 
add_action( 'widgets_init', function () {
	register_widget( 'ctw_optin_form' );  //WidgetをWordPressに登録する
} );
