<?php
/**
 * Catch the web MM Module Parts in the TinyMCE
 *
 */

// Adds button to mce
function ctw_parts_add_mce_button() {
	// check user permissions
	if ( !current_user_can( 'edit_posts' ) && !current_user_can( 'edit_pages' ) ) {
		return;
	}
	// check if WYSIWYG is enabled
	if ( 'true' == get_user_option( 'rich_editing' ) ) {
		add_filter( 'mce_external_plugins', 'ctw_parts_add_tinymce_plugin' );
		add_filter( 'mce_buttons_3', 'ctw_parts_register_mce_button' );
	}
}
add_action('admin_head', 'ctw_parts_add_mce_button');

// Loads js for the Button
function ctw_parts_add_tinymce_plugin($plugin_array) {
	$plugin_array['ctw_parts_mce_button'] = get_template_directory_uri().'/ctw/js/ctw_parts_tinymce.js';
	return $plugin_array;
}

// Registers new button
function ctw_parts_register_mce_button( $buttons ) {
	array_push( $buttons, 'ctw_parts_mce_button' );
	return $buttons;
}


//==========================================================================
//  テーマフォルダ内の画像を掲載
//==========================================================================

// （１）ショートコードを登録

function shortcode_templateurl() {
	return get_bloginfo('template_url');
}
add_shortcode('template_url', 'shortcode_templateurl');

// （２）自作したショートコードをビジュアルエディタ内で置換
// （注）editor_plugin.jsの「テーマフォルダ名」をテーマごとに変更するのを忘れないように。

class EditorPlugin {
	function EditorPlugin() {
		add_action('init', array(&$this, 'addplugin'));
	}
	function sink_hooks(){
		add_filter('mce_plugins', array(&$this, 'mce_plugins'));
	}
	function addplugin() {
		if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
		return;
		//リッチエディタの時だけ追加
		if ( get_user_option('rich_editing') == 'true') {
		 add_filter("mce_external_plugins", array(&$this, 'mce_external_plugins'));
		}
	}
	// TinyMCE プラグインファイルを読み込む: editor_plugin.js
	function mce_external_plugins($plugin_array) {
		//プラグイン関数名＝ファイルの位置
		$plugin_array['ShortcodeConv'] = get_template_directory_uri().'/ctw/js/editor_plugin.js';
		return $plugin_array;
	}
}
$myeditorplugin = new EditorPlugin();
add_action('init',array(&$myeditorplugin, 'EditorPlugin'));

//==========================================================================
//  imgタグのパスを絶対パスに置き換える
//==========================================================================

function replaceImagePath($arg) {
	$content = str_replace('"ctw/img/', '"' . get_bloginfo('template_directory') . '/ctw/img/', $arg);
	return $content;
}  
add_action('the_content', 'replaceImagePath');